/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.dao;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.dao.AsyncApiDao;
import com.yahoo.elide.async.service.dao.Transactional;
import com.yahoo.elide.async.service.dao.UpdateQuery;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.jsonapi.JsonApiRequestScope;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAsyncApiDao
implements AsyncApiDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncApiDao.class);
    private ElideSettings elideSettings;
    private DataStore dataStore;

    public DefaultAsyncApiDao() {
    }

    public DefaultAsyncApiDao(ElideSettings elideSettings, DataStore dataStore) {
        this.elideSettings = elideSettings;
        this.dataStore = dataStore;
    }

    @Override
    public <T extends AsyncApi> T updateStatus(String asyncApiId, QueryStatus status, Class<T> type) {
        AsyncApi queryObj = (AsyncApi)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncApiIterable = EntityProjection.builder().type(type).build();
            AsyncApi query = (AsyncApi)tx.loadObject(asyncApiIterable, (Serializable)((Object)asyncApiId), scope);
            query.setStatus(status);
            tx.save((Object)query, scope);
            return query;
        });
        return (T)queryObj;
    }

    @Override
    public <T extends AsyncApi> Iterable<T> updateStatusAsyncApiByFilter(FilterExpression filterExpression, QueryStatus status, Class<T> type) {
        return this.updateAsyncApiIterable(filterExpression, asyncApi -> asyncApi.setStatus(status), type);
    }

    private <T extends AsyncApi> Iterable<T> updateAsyncApiIterable(FilterExpression filterExpression, UpdateQuery updateFunction, Class<T> type) {
        log.debug("updateAsyncApiIterable");
        Iterable asyncApiList = null;
        asyncApiList = (Iterable)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncApiIterable = EntityProjection.builder().type(type).filterExpression(filterExpression).build();
            DataStoreIterable loaded = tx.loadObjects(asyncApiIterable, scope);
            for (AsyncApi query : loaded) {
                updateFunction.update(query);
                tx.save((Object)query, scope);
            }
            return loaded;
        });
        return asyncApiList;
    }

    @Override
    public <T extends AsyncApi> Iterable<T> deleteAsyncApiAndResultByFilter(FilterExpression filterExpression, Class<T> type) {
        log.debug("deleteAsyncApiAndResultByFilter");
        Iterable asyncApiList = null;
        asyncApiList = (Iterable)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncApiIterable = EntityProjection.builder().type(type).filterExpression(filterExpression).build();
            DataStoreIterable loaded = tx.loadObjects(asyncApiIterable, scope);
            for (AsyncApi query : loaded) {
                if (query == null) continue;
                tx.delete((Object)query, scope);
            }
            return loaded;
        });
        return asyncApiList;
    }

    @Override
    public <T extends AsyncApi> T updateAsyncApiResult(AsyncApiResult asyncApiResult, String asyncApiId, Class<T> type) {
        log.debug("updateAsyncApiResult");
        AsyncApi queryObj = (AsyncApi)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncApiIterable = EntityProjection.builder().type(type).build();
            AsyncApi query = (AsyncApi)tx.loadObject(asyncApiIterable, (Serializable)((Object)asyncApiId), scope);
            query.setResult(asyncApiResult);
            if (query.getStatus().equals((Object)QueryStatus.CANCELLED)) {
                query.setStatus(QueryStatus.CANCEL_COMPLETE);
            } else if (!query.getStatus().equals((Object)QueryStatus.CANCEL_COMPLETE)) {
                query.setStatus(QueryStatus.COMPLETE);
            }
            tx.save((Object)query, scope);
            return query;
        });
        return (T)queryObj;
    }

    protected Object executeInTransaction(DataStore dataStore, Transactional action) {
        log.debug("executeInTransaction");
        Object result = null;
        try (DataStoreTransaction tx = dataStore.beginTransaction();){
            JsonApiDocument jsonApiDoc = new JsonApiDocument();
            Route route = Route.builder().path("query").apiVersion("").build();
            JsonApiRequestScope scope = JsonApiRequestScope.builder().route(route).dataStoreTransaction(tx).requestId(UUID.randomUUID()).elideSettings(this.elideSettings).jsonApiDocument(jsonApiDoc).build();
            result = action.execute(tx, (RequestScope)scope);
            tx.flush((RequestScope)scope);
            tx.commit((RequestScope)scope);
        }
        catch (IOException e) {
            log.error("IOException: {}", (Object)e.toString());
            throw new IllegalStateException(e);
        }
        return result;
    }

    @Override
    public <T extends AsyncApi> Iterable<T> loadAsyncApiByFilter(FilterExpression filterExpression, Class<T> type) {
        Iterable asyncApiList = null;
        log.debug("loadAsyncApiByFilter");
        try {
            asyncApiList = (Iterable)this.executeInTransaction(this.dataStore, (tx, scope) -> {
                EntityProjection asyncApiIterable = EntityProjection.builder().type(type).filterExpression(filterExpression).build();
                return tx.loadObjects(asyncApiIterable, scope);
            });
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.toString());
            throw new IllegalStateException(e);
        }
        return asyncApiList;
    }

    @Generated
    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    @Generated
    public DataStore getDataStore() {
        return this.dataStore;
    }

    @Generated
    public void setElideSettings(ElideSettings elideSettings) {
        this.elideSettings = elideSettings;
    }

    @Generated
    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }
}

