/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.storageengine;

import com.yahoo.elide.async.models.TableExportResult;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import jakarta.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FileResultStorageEngine
implements ResultStorageEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileResultStorageEngine.class);
    private String basePath;

    public FileResultStorageEngine(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public TableExportResult storeResults(String tableExportID, Consumer<OutputStream> result) {
        log.debug("store TableExportResults for Download");
        TableExportResult exportResult = new TableExportResult();
        try (OutputStream writer = this.newOutputStream(tableExportID);){
            result.accept(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to store results.", e);
        }
        return exportResult;
    }

    @Override
    public Consumer<OutputStream> getResultsByID(String tableExportID) {
        log.debug("getTableExportResultsByID");
        return outputStream -> {
            try {
                this.newInputStream(tableExportID).transferTo((OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    protected void validatePath(Path path) throws IOException {
        Path parent = Paths.get(this.basePath, new String[0]);
        if (!path.getParent().equals(parent)) {
            throw new FileNotFoundException();
        }
    }

    private InputStream newInputStream(String tableExportID) {
        try {
            Path path = Paths.get(this.basePath, tableExportID);
            this.validatePath(path);
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            throw new UncheckedIOException("Unable to retrieve results.", e);
        }
    }

    private OutputStream newOutputStream(String tableExportID) {
        try {
            Path path = Paths.get(this.basePath, tableExportID);
            this.validatePath(path);
            return Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            throw new UncheckedIOException("Unable to store results.", e);
        }
    }

    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Generated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

