/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.storageengine;

import com.yahoo.elide.async.io.ByteSinkOutputStream;
import com.yahoo.elide.async.models.TableExportResult;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import jakarta.inject.Singleton;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.UnifiedJedis;

@Singleton
public class RedisResultStorageEngine
implements ResultStorageEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisResultStorageEngine.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private UnifiedJedis jedis;
    private long expirationSeconds;
    private long batchSize;
    private int bufferSize = 8192;

    public RedisResultStorageEngine(UnifiedJedis jedis, long expirationSeconds, long batchSize) {
        this.jedis = jedis;
        this.expirationSeconds = expirationSeconds;
        this.batchSize = batchSize;
    }

    @Override
    public TableExportResult storeResults(String tableExportID, Consumer<OutputStream> result) {
        log.debug("store TableExportResults for Download");
        TableExportResult exportResult = new TableExportResult();
        String key = tableExportID;
        try (OutputStream outputStream = this.newBufferedOutputStream(key, this.bufferSize);){
            result.accept(outputStream);
        }
        catch (IOException e) {
            this.setMessage(exportResult, e);
            throw new UncheckedIOException("Unable to store results.", e);
        }
        catch (UncheckedIOException e) {
            this.setMessage(exportResult, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.setMessage(exportResult, e);
            throw new UncheckedIOException("Unable to store results.", new IOException(e));
        }
        this.jedis.expire(key, this.expirationSeconds);
        return exportResult;
    }

    protected void setMessage(TableExportResult exportResult, Exception e) {
        StringBuilder message = new StringBuilder();
        message.append(e.getClass().getCanonicalName()).append(" : ");
        message.append(e.getMessage());
        exportResult.setMessage(message.toString());
    }

    protected OutputStream newBufferedOutputStream(String key, int size) {
        return new BufferedOutputStream(this.newOutputStream(key), size);
    }

    protected OutputStream newOutputStream(String key) {
        return new RedisOutputStream(data -> this.jedis.rpush(key.getBytes(StandardCharsets.UTF_8), (byte[][])new byte[][]{data}), () -> this.jedis.rpush(key.getBytes(StandardCharsets.UTF_8), (byte[][])new byte[][]{new byte[0]}));
    }

    @Override
    public Consumer<OutputStream> getResultsByID(String tableExportID) {
        log.debug("getTableExportResultsByID");
        long recordCount = this.jedis.llen(tableExportID);
        if (recordCount == 0L) {
            throw new IllegalStateException("Unable to retrieve results.");
        }
        return outputStream -> {
            long recordRead = 0L;
            while (recordRead < recordCount) {
                long end = recordRead + this.batchSize - 1L;
                if (end >= recordCount) {
                    end = recordCount - 1L;
                }
                for (byte[] data : this.jedis.lrange(tableExportID.getBytes(StandardCharsets.UTF_8), recordRead, end)) {
                    try {
                        outputStream.write(data);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                recordRead = end + 1L;
            }
        };
    }

    @Generated
    public UnifiedJedis getJedis() {
        return this.jedis;
    }

    @Generated
    public long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    @Generated
    public long getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Generated
    public void setJedis(UnifiedJedis jedis) {
        this.jedis = jedis;
    }

    @Generated
    public void setExpirationSeconds(long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    @Generated
    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public static class RedisOutputStream
    extends ByteSinkOutputStream {
        private final Runnable onEmpty;
        private boolean empty = true;

        public RedisOutputStream(Consumer<byte[]> byteSink, Runnable onEmpty) {
            super(byteSink);
            this.onEmpty = onEmpty;
        }

        @Override
        public void write(int b) throws IOException {
            this.empty = false;
            super.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.empty = false;
            super.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.empty = false;
            super.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.empty && this.onEmpty != null) {
                this.onEmpty.run();
            }
        }
    }
}

