/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.thread;

import com.google.common.collect.Sets;
import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.dao.AsyncApiDao;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.jsonapi.JsonApiRequestScope;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.time.Duration;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncApiCancelRunnable
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncApiCancelRunnable.class);
    private long queryMaxRunTimeSeconds;
    private Elide elide;
    private AsyncApiDao asyncApiDao;

    public AsyncApiCancelRunnable(Duration queryMaxRunTime, Elide elide, AsyncApiDao asyncApiDao) {
        this.queryMaxRunTimeSeconds = queryMaxRunTime.toSeconds();
        this.elide = elide;
        this.asyncApiDao = asyncApiDao;
    }

    @Override
    public void run() {
        this.cancelAsyncApi(AsyncQuery.class);
    }

    protected <T extends AsyncApi> void cancelAsyncApi(Class<T> type) {
        try {
            TransactionRegistry transactionRegistry = this.elide.getTransactionRegistry();
            Map runningTransactionMap = transactionRegistry.getRunningTransactions();
            Set runningTransactionUUIDs = runningTransactionMap.keySet();
            Path.PathElement statusPathElement = new Path.PathElement(type, QueryStatus.class, "status");
            InPredicate fltStatusExpression = new InPredicate(statusPathElement, (Object[])new QueryStatus[]{QueryStatus.CANCELLED, QueryStatus.PROCESSING, QueryStatus.QUEUED});
            Iterable asyncApiIterable = this.asyncApiDao.loadAsyncApiByFilter((FilterExpression)fltStatusExpression, type);
            Set asyncTransactionUUIDs = StreamSupport.stream(asyncApiIterable.spliterator(), false).filter(query -> query.getStatus() == QueryStatus.CANCELLED || TimeUnit.SECONDS.convert(Math.abs(new Date(System.currentTimeMillis()).getTime() - query.getCreatedOn().getTime()), TimeUnit.MILLISECONDS) > this.queryMaxRunTimeSeconds).map(query -> UUID.fromString(query.getRequestId())).collect(Collectors.toSet());
            Sets.SetView queryUUIDsToCancel = Sets.intersection(runningTransactionUUIDs, asyncTransactionUUIDs);
            Set queryIDsToCancel = queryUUIDsToCancel.stream().map(uuid -> StreamSupport.stream(asyncApiIterable.spliterator(), false).filter(query -> query.getRequestId().equals(uuid.toString())).map(AsyncApi::getId).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toSet());
            queryUUIDsToCancel.stream().forEach(uuid -> {
                DataStoreTransaction runningTransaction = transactionRegistry.getRunningTransaction(uuid);
                if (runningTransaction != null) {
                    JsonApiDocument jsonApiDoc = new JsonApiDocument();
                    LinkedHashMap queryParams = new LinkedHashMap();
                    Route route = Route.builder().path("query").apiVersion("").parameters(queryParams).build();
                    JsonApiRequestScope scope = JsonApiRequestScope.builder().route(route).dataStoreTransaction(runningTransaction).requestId(uuid).elideSettings(this.elide.getElideSettings()).jsonApiDocument(jsonApiDoc).build();
                    runningTransaction.cancel((RequestScope)scope);
                }
            });
            if (!queryIDsToCancel.isEmpty()) {
                Path.PathElement idPathElement = new Path.PathElement(type, String.class, "id");
                InPredicate fltIdExpression = new InPredicate(idPathElement, (Object[])new Set[]{queryIDsToCancel});
                this.asyncApiDao.updateStatusAsyncApiByFilter((FilterExpression)fltIdExpression, QueryStatus.CANCEL_COMPLETE, type);
            }
        }
        catch (Exception e) {
            log.error("Exception in scheduled cancellation: {}", (Object)e.toString());
        }
    }

    @Generated
    public long getQueryMaxRunTimeSeconds() {
        return this.queryMaxRunTimeSeconds;
    }

    @Generated
    public Elide getElide() {
        return this.elide;
    }

    @Generated
    public AsyncApiDao getAsyncApiDao() {
        return this.asyncApiDao;
    }

    @Generated
    public void setQueryMaxRunTimeSeconds(long queryMaxRunTimeSeconds) {
        this.queryMaxRunTimeSeconds = queryMaxRunTimeSeconds;
    }

    @Generated
    public void setElide(Elide elide) {
        this.elide = elide;
    }

    @Generated
    public void setAsyncApiDao(AsyncApiDao asyncApiDao) {
        this.asyncApiDao = asyncApiDao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncApiCancelRunnable)) {
            return false;
        }
        AsyncApiCancelRunnable other = (AsyncApiCancelRunnable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQueryMaxRunTimeSeconds() != other.getQueryMaxRunTimeSeconds()) {
            return false;
        }
        Elide this$elide = this.getElide();
        Elide other$elide = other.getElide();
        if (this$elide == null ? other$elide != null : !this$elide.equals(other$elide)) {
            return false;
        }
        AsyncApiDao this$asyncApiDao = this.getAsyncApiDao();
        AsyncApiDao other$asyncApiDao = other.getAsyncApiDao();
        return !(this$asyncApiDao == null ? other$asyncApiDao != null : !this$asyncApiDao.equals(other$asyncApiDao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncApiCancelRunnable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $queryMaxRunTimeSeconds = this.getQueryMaxRunTimeSeconds();
        result = result * 59 + (int)($queryMaxRunTimeSeconds >>> 32 ^ $queryMaxRunTimeSeconds);
        Elide $elide = this.getElide();
        result = result * 59 + ($elide == null ? 43 : $elide.hashCode());
        AsyncApiDao $asyncApiDao = this.getAsyncApiDao();
        result = result * 59 + ($asyncApiDao == null ? 43 : $asyncApiDao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AsyncApiCancelRunnable(queryMaxRunTimeSeconds=" + this.getQueryMaxRunTimeSeconds() + ", elide=" + this.getElide() + ", asyncApiDao=" + this.getAsyncApiDao() + ")";
    }
}

