/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.filter.visitors.FilterExpressionNormalizationVisitor;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.HasJoinVisitor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import java.util.List;

public class SubqueryFilterSplitter
implements FilterExpressionVisitor<SplitFilter> {
    private MetaDataStore metaDataStore;
    private ExpressionParser parser;

    public SubqueryFilterSplitter(MetaDataStore metaDataStore) {
        this.metaDataStore = metaDataStore;
        this.parser = new ExpressionParser(metaDataStore);
    }

    public static SplitFilter splitFilter(MetaDataStore metaDataStore, FilterExpression expression) {
        if (expression == null) {
            return SplitFilter.builder().build();
        }
        FilterExpressionNormalizationVisitor normalizer = new FilterExpressionNormalizationVisitor();
        FilterExpression normalizedExpression = (FilterExpression)expression.accept((FilterExpressionVisitor)normalizer);
        return (SplitFilter)normalizedExpression.accept((FilterExpressionVisitor)new SubqueryFilterSplitter(metaDataStore));
    }

    public SplitFilter visitPredicate(FilterPredicate filterPredicate) {
        Type tableType = filterPredicate.getEntityType();
        String fieldName = filterPredicate.getField();
        SQLTable table = (SQLTable)this.metaDataStore.getTable(tableType);
        List<Reference> references = this.parser.parse((Queryable)table, table.getColumnProjection(fieldName));
        boolean hasJoin = references.stream().anyMatch(ref -> ref.accept(new HasJoinVisitor()));
        if (hasJoin) {
            return SplitFilter.builder().outer((FilterExpression)filterPredicate).build();
        }
        return SplitFilter.builder().inner((FilterExpression)filterPredicate).build();
    }

    public SplitFilter visitAndExpression(AndFilterExpression expression) {
        SplitFilter lhs = (SplitFilter)expression.getLeft().accept((FilterExpressionVisitor)this);
        SplitFilter rhs = (SplitFilter)expression.getRight().accept((FilterExpressionVisitor)this);
        return SplitFilter.builder().outer(AndFilterExpression.fromPair((FilterExpression)lhs.getOuter(), (FilterExpression)rhs.getOuter())).inner(AndFilterExpression.fromPair((FilterExpression)lhs.getInner(), (FilterExpression)rhs.getInner())).build();
    }

    public SplitFilter visitOrExpression(OrFilterExpression expression) {
        SplitFilter lhs = (SplitFilter)expression.getLeft().accept((FilterExpressionVisitor)this);
        SplitFilter rhs = (SplitFilter)expression.getRight().accept((FilterExpressionVisitor)this);
        if (lhs.getOuter() != null || rhs.getOuter() != null) {
            FilterExpression combined = OrFilterExpression.fromPair((FilterExpression)AndFilterExpression.fromPair((FilterExpression)lhs.getOuter(), (FilterExpression)lhs.getInner()), (FilterExpression)AndFilterExpression.fromPair((FilterExpression)rhs.getOuter(), (FilterExpression)rhs.getInner()));
            return SplitFilter.builder().outer(combined).build();
        }
        FilterExpression combined = OrFilterExpression.fromPair((FilterExpression)lhs.getInner(), (FilterExpression)rhs.getInner());
        return SplitFilter.builder().inner(combined).build();
    }

    public SplitFilter visitNotExpression(NotFilterExpression expression) {
        SplitFilter negated = (SplitFilter)expression.getNegated().accept((FilterExpressionVisitor)this);
        NotFilterExpression outerFilter = negated.getOuter() == null ? null : new NotFilterExpression(negated.getOuter());
        NotFilterExpression innerFilter = negated.getInner() == null ? null : new NotFilterExpression(negated.getInner());
        return SplitFilter.builder().outer((FilterExpression)outerFilter).inner((FilterExpression)innerFilter).build();
    }

    public static class SplitFilter {
        FilterExpression outer;
        FilterExpression inner;

        SplitFilter(FilterExpression outer, FilterExpression inner) {
            this.outer = outer;
            this.inner = inner;
        }

        public static SplitFilterBuilder builder() {
            return new SplitFilterBuilder();
        }

        public FilterExpression getOuter() {
            return this.outer;
        }

        public FilterExpression getInner() {
            return this.inner;
        }

        public void setOuter(FilterExpression outer) {
            this.outer = outer;
        }

        public void setInner(FilterExpression inner) {
            this.inner = inner;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SplitFilter)) {
                return false;
            }
            SplitFilter other = (SplitFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FilterExpression this$outer = this.getOuter();
            FilterExpression other$outer = other.getOuter();
            if (this$outer == null ? other$outer != null : !this$outer.equals(other$outer)) {
                return false;
            }
            FilterExpression this$inner = this.getInner();
            FilterExpression other$inner = other.getInner();
            return !(this$inner == null ? other$inner != null : !this$inner.equals(other$inner));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SplitFilter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FilterExpression $outer = this.getOuter();
            result = result * 59 + ($outer == null ? 43 : $outer.hashCode());
            FilterExpression $inner = this.getInner();
            result = result * 59 + ($inner == null ? 43 : $inner.hashCode());
            return result;
        }

        public String toString() {
            return "SubqueryFilterSplitter.SplitFilter(outer=" + this.getOuter() + ", inner=" + this.getInner() + ")";
        }

        public static class SplitFilterBuilder {
            private FilterExpression outer;
            private FilterExpression inner;

            SplitFilterBuilder() {
            }

            public SplitFilterBuilder outer(FilterExpression outer) {
                this.outer = outer;
                return this;
            }

            public SplitFilterBuilder inner(FilterExpression inner) {
                this.inner = inner;
                return this;
            }

            public SplitFilter build() {
                return new SplitFilter(this.outer, this.inner);
            }

            public String toString() {
                return "SubqueryFilterSplitter.SplitFilter.SplitFilterBuilder(outer=" + this.outer + ", inner=" + this.inner + ")";
            }
        }
    }
}

