/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.datastores.aggregation.annotation.Temporal;
import com.yahoo.elide.datastores.aggregation.annotation.TimeGrainDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimensionGrain;
import jakarta.persistence.ManyToMany;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.TimeZone;
import java.util.stream.Collectors;

@Include(rootLevel=false, name="timeDimension")
public final class TimeDimension
extends Column {
    @ManyToMany
    private final LinkedHashSet<TimeDimensionGrain> supportedGrains;
    private final TimeZone timezone = TimeZone.getTimeZone("UTC");

    public TimeDimension(Table table, String fieldName, EntityDictionary dictionary) {
        super(table, fieldName, dictionary);
        Temporal temporal = (Temporal)dictionary.getAttributeOrRelationAnnotation(dictionary.getEntityClass(table.getName(), table.getVersion()), Temporal.class, fieldName);
        this.supportedGrains = temporal.grains().length == 0 ? new LinkedHashSet<TimeDimensionGrain>(Arrays.asList(new TimeDimensionGrain(this.getId(), TimeGrain.DAY))) : Arrays.stream(temporal.grains()).map(grain -> new TimeDimensionGrain(this.getId(), (TimeGrainDefinition)grain)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public TimeDimensionGrain getDefaultGrain() {
        return (TimeDimensionGrain)this.supportedGrains.iterator().next();
    }

    public LinkedHashSet<TimeDimensionGrain> getSupportedGrains() {
        return this.supportedGrains;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    @Override
    public String toString() {
        return "TimeDimension(timezone=" + this.getTimezone() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeDimension)) {
            return false;
        }
        TimeDimension other = (TimeDimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinkedHashSet<TimeDimensionGrain> this$supportedGrains = this.getSupportedGrains();
        LinkedHashSet<TimeDimensionGrain> other$supportedGrains = other.getSupportedGrains();
        if (this$supportedGrains == null ? other$supportedGrains != null : !((Object)this$supportedGrains).equals(other$supportedGrains)) {
            return false;
        }
        TimeZone this$timezone = this.getTimezone();
        TimeZone other$timezone = other.getTimezone();
        return !(this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeDimension;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LinkedHashSet<TimeDimensionGrain> $supportedGrains = this.getSupportedGrains();
        result = result * 59 + ($supportedGrains == null ? 43 : ((Object)$supportedGrains).hashCode());
        TimeZone $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        return result;
    }
}

