/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite;

import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CharLiteralStyle;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.parser.SqlParser;

public class CalciteUtils {
    public static SqlParser.Config constructParserConfig(SQLDialect dialect) {
        SqlDialect calciteDialect = dialect.getCalciteDialect();
        return SqlParser.config().withQuoting(switch (dialect.getBeginQuote()) {
            case '`' -> Quoting.BACK_TICK;
            case '\"' -> Quoting.DOUBLE_QUOTE;
            case '[' -> Quoting.BRACKET;
            default -> throw new IllegalStateException("Unrecognized identifier quotation mark");
        }).withConformance(calciteDialect.getConformance()).withUnquotedCasing(calciteDialect.getUnquotedCasing()).withQuotedCasing(calciteDialect.getQuotedCasing()).withCharLiteralStyles(new HashSet<CharLiteralStyle>(Arrays.asList(CharLiteralStyle.STANDARD))).withCaseSensitive(calciteDialect.isCaseSensitive());
    }
}

