/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.expression;

import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceVisitor;
import lombok.NonNull;

public final class PhysicalReference
implements Reference {
    @NonNull
    private final Queryable source;
    @NonNull
    private final String name;

    @Override
    public <T> T accept(ReferenceVisitor<T> visitor) {
        return visitor.visitPhysicalReference(this);
    }

    PhysicalReference(@NonNull Queryable source, @NonNull String name) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.source = source;
        this.name = name;
    }

    public static PhysicalReferenceBuilder builder() {
        return new PhysicalReferenceBuilder();
    }

    @NonNull
    public Queryable getSource() {
        return this.source;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalReference)) {
            return false;
        }
        PhysicalReference other = (PhysicalReference)o;
        Queryable this$source = this.getSource();
        Queryable other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Queryable $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "PhysicalReference(source=" + this.getSource() + ", name=" + this.getName() + ")";
    }

    public static class PhysicalReferenceBuilder {
        private Queryable source;
        private String name;

        PhysicalReferenceBuilder() {
        }

        public PhysicalReferenceBuilder source(@NonNull Queryable source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        public PhysicalReferenceBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public PhysicalReference build() {
            return new PhysicalReference(this.source, this.name);
        }

        public String toString() {
            return "PhysicalReference.PhysicalReferenceBuilder(source=" + this.source + ", name=" + this.name + ")";
        }
    }
}

