/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.EntityProjectionTranslator;
import com.yahoo.elide.datastores.aggregation.QueryEngine;
import com.yahoo.elide.datastores.aggregation.cache.Cache;
import com.yahoo.elide.datastores.aggregation.cache.QueryKeyExtractor;
import com.yahoo.elide.datastores.aggregation.core.QueryLogger;
import com.yahoo.elide.datastores.aggregation.core.QueryResponse;
import com.yahoo.elide.datastores.aggregation.filter.visitor.MatchesTemplateVisitor;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.RequiresFilter;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.QueryResult;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class AggregationDataStoreTransaction
implements DataStoreTransaction {
    private final QueryEngine queryEngine;
    private final Cache cache;
    private final QueryEngine.Transaction queryEngineTransaction;
    private final QueryLogger queryLogger;
    private final MetaDataStore metaDataStore;

    public AggregationDataStoreTransaction(QueryEngine queryEngine, Cache cache, QueryLogger queryLogger) {
        this.queryEngine = queryEngine;
        this.cache = cache;
        this.queryEngineTransaction = queryEngine.beginTransaction();
        this.queryLogger = queryLogger;
        this.metaDataStore = queryEngine.getMetaDataStore();
    }

    public <T> void save(T entity, RequestScope scope) {
        this.throwReadOnlyException(entity);
    }

    public <T> void delete(T entity, RequestScope scope) {
        this.throwReadOnlyException(entity);
    }

    public void flush(RequestScope scope) {
    }

    public void commit(RequestScope scope) {
        this.queryEngineTransaction.close();
    }

    public <T> void createObject(T entity, RequestScope scope) {
        this.throwReadOnlyException(entity);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> DataStoreIterable<T> loadObjects(EntityProjection entityProjection, RequestScope scope) {
        QueryResult result = null;
        QueryResponse response = null;
        String cacheKey = null;
        try {
            Map<String, String> headers = scope.getRoute().getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.joining(" "))));
            this.queryLogger.acceptQuery(scope.getRequestId(), scope.getUser(), headers, scope.getRoute().getApiVersion(), scope.getRoute().getParameters(), scope.getRoute().getPath());
            Query query = this.buildQuery(entityProjection, scope);
            Table table = (Table)((Object)query.getSource());
            if (this.cache != null && !query.isBypassingCache()) {
                String tableVersion = this.queryEngine.getTableVersion(table, this.queryEngineTransaction);
                tableVersion = tableVersion == null ? "" : tableVersion;
                cacheKey = tableVersion + ";" + QueryKeyExtractor.extractKey(query);
                result = this.cache.get(cacheKey);
            }
            boolean isCached = result != null;
            List<String> queryText = this.queryEngine.explain(query);
            this.queryLogger.processQuery(scope.getRequestId(), query, queryText, isCached);
            if (result == null) {
                result = this.queryEngine.executeQuery(query, this.queryEngineTransaction);
                if (cacheKey != null) {
                    QueryResult cacheableResult = QueryResult.builder().data(Lists.newArrayList(result.getData().iterator())).pageTotals(result.getPageTotals()).build();
                    this.cache.put(cacheKey, cacheableResult);
                    result = cacheableResult;
                }
            }
            if (entityProjection.getPagination() != null && entityProjection.getPagination().returnPageTotals()) {
                entityProjection.getPagination().setPageTotals(result.getPageTotals());
            }
            response = new QueryResponse(200, result.getData(), null);
            DataStoreIterable dataStoreIterable = new DataStoreIterableBuilder(result.getData()).build();
            this.queryLogger.completeQuery(scope.getRequestId(), response);
            return dataStoreIterable;
        }
        catch (HttpStatusException e) {
            try {
                response = new QueryResponse(e.getStatus(), null, e.getMessage());
                throw e;
                catch (Exception e2) {
                    response = new QueryResponse(500, null, e2.getMessage());
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.queryLogger.completeQuery(scope.getRequestId(), response);
                throw throwable;
            }
        }
    }

    public void close() throws IOException {
        this.queryEngineTransaction.close();
    }

    @VisibleForTesting
    Query buildQuery(EntityProjection entityProjection, RequestScope scope) {
        Table table = this.metaDataStore.getTable(scope.getDictionary().getJsonAliasFor(entityProjection.getType()), scope.getRoute().getApiVersion());
        String bypassCacheStr = scope.getRoute().getHeaders().getOrDefault("bypasscache", Collections.emptyList()).stream().findFirst().orElse(null);
        Boolean bypassCache = "true".equals(bypassCacheStr);
        EntityProjectionTranslator translator = new EntityProjectionTranslator(this.queryEngine, table, entityProjection, scope, bypassCache);
        Query query = translator.getQuery();
        Query modifiedQuery = this.addTableFilterArguments(table, query, scope.getDictionary());
        modifiedQuery = this.addColumnFilterArguments(table, modifiedQuery, scope.getDictionary());
        return modifiedQuery;
    }

    @VisibleForTesting
    Query addTableFilterArguments(Table table, Query query, EntityDictionary dictionary) {
        Map<String, Argument> allArguments;
        FilterExpression filterTemplate = table.getRequiredFilter(dictionary);
        Query modifiedQuery = query;
        if (filterTemplate != null && !(allArguments = this.validateRequiredFilter(filterTemplate, query, table)).isEmpty()) {
            if (query.getArguments() != null) {
                allArguments.putAll(query.getArguments());
            }
            modifiedQuery = Query.builder().query(query).arguments(allArguments).build();
        }
        return modifiedQuery;
    }

    @VisibleForTesting
    Query addColumnFilterArguments(Table table, Query query, EntityDictionary dictionary) {
        Query.QueryBuilder queryBuilder = Query.builder();
        query.getColumnProjections().stream().forEach(projection -> {
            Column column = table.getColumn(Column.class, projection.getName());
            FilterExpression requiredFilter = column.getRequiredFilter(dictionary);
            if (requiredFilter != null) {
                Map<String, Argument> allArguments = this.validateRequiredFilter(requiredFilter, query, column);
                if (projection.getArguments() != null) {
                    allArguments.putAll(projection.getArguments());
                }
                queryBuilder.column(projection.withArguments(allArguments));
            } else {
                queryBuilder.column((ColumnProjection)projection);
            }
        });
        return queryBuilder.arguments(query.getArguments()).havingFilter(query.getHavingFilter()).whereFilter(query.getWhereFilter()).sorting(query.getSorting()).pagination(query.getPagination()).bypassingCache(query.isBypassingCache()).source(query.getSource()).scope(query.getScope()).build();
    }

    private Map<String, Argument> validateRequiredFilter(FilterExpression filterTemplate, Query query, RequiresFilter requiresFilter) {
        HashMap<String, Argument> templateFilterArguments = new HashMap<String, Argument>();
        if (!MatchesTemplateVisitor.isValid(filterTemplate, query.getWhereFilter(), templateFilterArguments) && !MatchesTemplateVisitor.isValid(filterTemplate, query.getHavingFilter(), templateFilterArguments)) {
            String message = String.format("Querying %s requires a mandatory filter: %s", requiresFilter.getName(), requiresFilter.getRequiredFilter());
            throw new BadRequestException(message);
        }
        return templateFilterArguments;
    }

    public void cancel(RequestScope scope) {
        this.queryLogger.cancelQuery(scope.getRequestId());
        this.queryEngineTransaction.cancel();
    }

    private <T> void throwReadOnlyException(T entity) {
        EntityDictionary dictionary = this.metaDataStore.getMetadataDictionary();
        Type type = EntityDictionary.getType(entity);
        throw new InvalidOperationException(dictionary.getJsonAliasFor(type) + " is read only.");
    }

    @Generated
    public String toString() {
        return "AggregationDataStoreTransaction(queryEngine=" + this.queryEngine + ", cache=" + this.cache + ", queryEngineTransaction=" + this.queryEngineTransaction + ", queryLogger=" + this.queryLogger + ", metaDataStore=" + this.metaDataStore + ")";
    }
}

