/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.datastores.aggregation.core.QueryLogger;
import com.yahoo.elide.datastores.aggregation.core.QueryResponse;
import com.yahoo.elide.datastores.aggregation.query.Query;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.LoggerFactory;

public class Slf4jQueryLogger
implements QueryLogger {
    @Generated
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Slf4jQueryLogger.class);
    private static final String ID = "id";
    private final ObjectMapper mapper = new ObjectMapper();
    private final Logger logger;

    public Slf4jQueryLogger() {
        this.logger = this::log;
    }

    public Slf4jQueryLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void acceptQuery(UUID queryId, User user, Map<String, String> headers, String apiVer, Map<String, List<String>> queryParams, String path) {
        ObjectNode rootNode = this.mapper.createObjectNode();
        rootNode.put(ID, queryId.toString());
        rootNode.put("user", user != null && user.getName() != null ? user.getName() : "Unknown");
        if (!queryParams.isEmpty()) {
            ObjectNode queryParamNode = rootNode.putObject("queryParams");
            queryParams.forEach((key, values) -> {
                ArrayNode listNode = queryParamNode.putArray(key);
                values.stream().forEach(arg_0 -> ((ArrayNode)listNode).add(arg_0));
            });
        }
        rootNode.put("apiVersion", apiVer);
        rootNode.put("path", path);
        ObjectNode headerNode = rootNode.putObject("headers");
        headers.forEach((arg_0, arg_1) -> ((ObjectNode)headerNode).put(arg_0, arg_1));
        this.logger.log("QUERY ACCEPTED: {}", (JsonNode)rootNode);
    }

    @Override
    public void processQuery(UUID queryId, Query query, List<String> apiQuery, boolean isCached) {
        ObjectNode rootNode = this.mapper.createObjectNode();
        rootNode.put(ID, queryId.toString());
        ArrayNode dbQueryNode = rootNode.putArray("queries");
        apiQuery.stream().forEach(arg_0 -> ((ArrayNode)dbQueryNode).add(arg_0));
        rootNode.put("isCached", isCached);
        this.logger.log("QUERY RUNNING: {}", (JsonNode)rootNode);
    }

    @Override
    public void cancelQuery(UUID queryId) {
        ObjectNode rootNode = this.mapper.createObjectNode();
        rootNode.put(ID, queryId.toString());
        this.logger.log("QUERY CANCELED: {}", (JsonNode)rootNode);
    }

    @Override
    public void completeQuery(UUID queryId, QueryResponse response) {
        ObjectNode rootNode = this.mapper.createObjectNode();
        rootNode.put(ID, queryId.toString());
        rootNode.put("status", response.getResponseCode());
        rootNode.put("error", response.getErrorMessage());
        this.logger.log("QUERY COMPLETE: {}", (JsonNode)rootNode);
    }

    protected void log(String template, JsonNode value) {
        log.debug(template, (Object)value);
    }

    @FunctionalInterface
    public static interface Logger {
        public void log(String var1, JsonNode var2);
    }
}

