/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.filter.visitor;

import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.filter.visitors.FilterExpressionNormalizationVisitor;
import com.yahoo.elide.datastores.aggregation.filter.visitor.FilterConstraints;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitFilterExpressionVisitor
implements FilterExpressionVisitor<FilterConstraints> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SplitFilterExpressionVisitor.class);
    private final Table table;
    private final FilterExpressionNormalizationVisitor normalizationVisitor;

    public SplitFilterExpressionVisitor(Table table) {
        this.table = Objects.requireNonNull(table, "table");
        this.normalizationVisitor = new FilterExpressionNormalizationVisitor();
    }

    public FilterConstraints visitPredicate(FilterPredicate filterPredicate) {
        return this.isHavingPredicate(filterPredicate) ? FilterConstraints.pureHaving((FilterExpression)filterPredicate) : FilterConstraints.pureWhere((FilterExpression)filterPredicate);
    }

    public FilterConstraints visitAndExpression(AndFilterExpression expression) {
        FilterConstraints left = (FilterConstraints)expression.getLeft().accept((FilterExpressionVisitor)this);
        FilterConstraints right = (FilterConstraints)expression.getRight().accept((FilterExpressionVisitor)this);
        if (left.isPureWhere() && right.isPureWhere()) {
            return FilterConstraints.pureWhere((FilterExpression)new AndFilterExpression(left.getWhereExpression(), right.getWhereExpression()));
        }
        if (left.isPureHaving() && right.isPureHaving()) {
            return FilterConstraints.pureHaving((FilterExpression)new AndFilterExpression(left.getHavingExpression(), right.getHavingExpression()));
        }
        return FilterConstraints.withWhereAndHaving(AndFilterExpression.fromPair((FilterExpression)left.getWhereExpression(), (FilterExpression)right.getWhereExpression()), AndFilterExpression.fromPair((FilterExpression)left.getHavingExpression(), (FilterExpression)right.getHavingExpression()));
    }

    public FilterConstraints visitOrExpression(OrFilterExpression expression) {
        FilterConstraints left = (FilterConstraints)expression.getLeft().accept((FilterExpressionVisitor)this);
        FilterConstraints right = (FilterConstraints)expression.getRight().accept((FilterExpressionVisitor)this);
        if (left.isPureWhere() && right.isPureWhere()) {
            return FilterConstraints.pureWhere(OrFilterExpression.fromPair((FilterExpression)left.getWhereExpression(), (FilterExpression)right.getWhereExpression()));
        }
        return FilterConstraints.pureHaving(OrFilterExpression.fromPair((FilterExpression)AndFilterExpression.fromPair((FilterExpression)left.getWhereExpression(), (FilterExpression)left.getHavingExpression()), (FilterExpression)AndFilterExpression.fromPair((FilterExpression)right.getWhereExpression(), (FilterExpression)right.getHavingExpression())));
    }

    public FilterConstraints visitNotExpression(NotFilterExpression expression) {
        FilterExpression normalized = this.getNormalizationVisitor().visitNotExpression(expression);
        if (normalized instanceof AndFilterExpression) {
            return this.visitAndExpression((AndFilterExpression)normalized);
        }
        if (normalized instanceof OrFilterExpression) {
            return this.visitOrExpression((OrFilterExpression)normalized);
        }
        if (normalized instanceof NotFilterExpression) {
            FilterConstraints negatedConstraint = this.visitNotExpression((NotFilterExpression)normalized);
            if (negatedConstraint.isPureWhere()) {
                return FilterConstraints.pureWhere((FilterExpression)new NotFilterExpression(negatedConstraint.getWhereExpression()));
            }
            return FilterConstraints.pureHaving((FilterExpression)new NotFilterExpression(negatedConstraint.getHavingExpression()));
        }
        return this.visitPredicate((FilterPredicate)normalized);
    }

    private boolean isHavingPredicate(FilterPredicate filterPredicate) {
        String fieldName = filterPredicate.getField();
        return this.getTable().isMetric(fieldName);
    }

    @Generated
    private Table getTable() {
        return this.table;
    }

    @Generated
    private FilterExpressionNormalizationVisitor getNormalizationVisitor() {
        return this.normalizationVisitor;
    }
}

