/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata;

import com.yahoo.elide.annotation.ApiVersion;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.datastore.inmemory.HashMapDataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.EntityDictionaryBuilderCustomizer;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.exceptions.DuplicateMappingException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.aggregation.AggregationDataStore;
import com.yahoo.elide.datastores.aggregation.annotation.MetricFormula;
import com.yahoo.elide.datastores.aggregation.dynamic.NamespacePackage;
import com.yahoo.elide.datastores.aggregation.dynamic.TableType;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStoreTransaction;
import com.yahoo.elide.datastores.aggregation.metadata.models.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Metric;
import com.yahoo.elide.datastores.aggregation.metadata.models.Namespace;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TableSource;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimensionGrain;
import com.yahoo.elide.datastores.aggregation.metadata.models.Versioned;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable;
import com.yahoo.elide.modelconfig.model.NamespaceConfig;
import jakarta.persistence.Entity;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.annotations.Subselect;

public class MetaDataStore
implements DataStore {
    private static final Package META_DATA_PACKAGE = Table.class.getPackage();
    private static final List<Class<? extends Annotation>> METADATA_STORE_ANNOTATIONS = Arrays.asList(FromTable.class, FromSubquery.class, Subselect.class, jakarta.persistence.Table.class, Entity.class);
    private static final Function<String, HashMapDataStore> SERVER_ERROR = key -> {
        throw new InternalServerErrorException("API version " + key + " not found");
    };
    private final Set<Type<?>> modelsToBind;
    private final Map<Pair<String, String>, NamespacePackage> namespacesToBind = new HashMap<Pair<String, String>, NamespacePackage>();
    private boolean enableMetaDataStore = false;
    private Map<Type<?>, Table> tables = new HashMap();
    private Set<Namespace> namespaces = new HashSet<Namespace>();
    private final EntityDictionary metadataDictionary;
    private Map<String, HashMapDataStore> hashMapDataStores = new HashMap<String, HashMapDataStore>();
    private final Set<Class<?>> metadataModelClasses;

    public MetaDataStore(ClassScanner scanner, Injector injector, Collection<com.yahoo.elide.modelconfig.model.Table> tables, boolean enableMetaDataStore) {
        this(scanner, injector, tables, new HashSet<NamespaceConfig>(), enableMetaDataStore);
    }

    public MetaDataStore(ClassScanner scanner, Collection<com.yahoo.elide.modelconfig.model.Table> tables, Collection<NamespaceConfig> namespaceConfigs, boolean enableMetaDataStore) {
        this(scanner, EntityDictionary.DEFAULT_INJECTOR, tables, namespaceConfigs, enableMetaDataStore);
    }

    public MetaDataStore(ClassScanner scanner, Injector injector, Collection<com.yahoo.elide.modelconfig.model.Table> tables, Collection<NamespaceConfig> namespaceConfigs, boolean enableMetaDataStore) {
        this(entityDictionaryBuilder -> entityDictionaryBuilder.scanner(scanner).injector(injector), TypeHelper.getClassType(MetaDataStore.getAllAnnotatedClasses(scanner)), enableMetaDataStore);
        HashMap typeMap = new HashMap();
        HashSet joinNames = new HashSet();
        HashSet dynamicTypes = new HashSet();
        namespaceConfigs.stream().forEach(namespace -> {
            NamespacePackage namespacePackage = new NamespacePackage((NamespaceConfig)namespace);
            ApiVersion apiVersion = namespacePackage.getDeclaredAnnotation(ApiVersion.class);
            String apiVersionName = apiVersion != null ? apiVersion.version() : "";
            Pair registration = Pair.of((Object)namespacePackage.getName(), (Object)apiVersionName);
            this.namespacesToBind.put((Pair<String, String>)registration, namespacePackage);
        });
        tables.stream().forEach(table -> {
            Pair registration = Pair.of((Object)table.getNamespace(), (Object)"");
            if (!this.namespacesToBind.containsKey(registration)) {
                if (table.getNamespace() != "default") {
                    throw new IllegalStateException("No matching namespace found: " + table.getNamespace());
                }
                registration = Pair.of((Object)"", (Object)"");
                this.namespacesToBind.put((Pair<String, String>)registration, NamespacePackage.DEFAULT_NAMESPACE);
            }
            TableType tableType = new TableType((com.yahoo.elide.modelconfig.model.Table)table, this.namespacesToBind.get(registration));
            dynamicTypes.add(tableType);
            typeMap.put(table.getGlobalName(), tableType);
            table.getJoins().stream().forEach(join -> joinNames.add(join.getTo()));
        });
        this.metadataDictionary.getBindings().stream().filter(binding -> joinNames.contains(binding.getJsonApiType())).forEach(staticType -> typeMap.put(staticType.getJsonApiType(), staticType.getEntityClass()));
        dynamicTypes.stream().forEach(table -> {
            ((TableType)table).resolveJoins(typeMap);
            String version = EntityDictionary.getModelVersion((Type)table);
            HashMapDataStore hashMapDataStore = this.hashMapDataStores.computeIfAbsent(version, this.getHashMapDataStoreInitializer(entityDictionaryBuilder -> entityDictionaryBuilder.scanner(scanner).injector(injector)));
            hashMapDataStore.getDictionary().bindEntity(table, AggregationDataStore.IS_FIELD_HIDDEN);
            this.metadataDictionary.bindEntity(table, AggregationDataStore.IS_FIELD_HIDDEN);
            this.modelsToBind.add((Type<?>)table);
            this.hashMapDataStores.putIfAbsent(version, hashMapDataStore);
        });
    }

    public MetaDataStore(ClassScanner scanner, boolean enableMetaDataStore) {
        this(scanner, EntityDictionary.DEFAULT_INJECTOR, enableMetaDataStore);
    }

    public MetaDataStore(ClassScanner scanner, Injector injector, boolean enableMetaDataStore) {
        this(entityDictionaryBuilder -> entityDictionaryBuilder.scanner(scanner).injector(injector), TypeHelper.getClassType(MetaDataStore.getAllAnnotatedClasses(scanner)), enableMetaDataStore);
    }

    private static Set<Class<?>> getAllAnnotatedClasses(ClassScanner scanner) {
        return scanner.getAnnotatedClasses(METADATA_STORE_ANNOTATIONS, clazz -> clazz.getAnnotation(Entity.class) == null || clazz.getAnnotation(Include.class) != null);
    }

    public Set<Type<?>> getDynamicTypes() {
        return this.modelsToBind.stream().filter(type -> type instanceof TableType).collect(Collectors.toSet());
    }

    public MetaDataStore(ClassScanner scanner, Set<Type<?>> modelsToBind, boolean enableMetaDataStore) {
        this(entityDictionaryBuilder -> entityDictionaryBuilder.scanner(scanner), modelsToBind, enableMetaDataStore);
    }

    public MetaDataStore(EntityDictionaryBuilderCustomizer entityDictionaryBuilderCustomizer, Set<Type<?>> modelsToBind, boolean enableMetaDataStore) {
        EntityDictionary.EntityDictionaryBuilder builder = EntityDictionary.builder();
        entityDictionaryBuilderCustomizer.customize(builder);
        this.metadataDictionary = builder.build();
        this.metadataModelClasses = new HashSet<Class>(Arrays.asList(Column.class, Metric.class, ArgumentDefinition.class, TableSource.class, Dimension.class, TimeDimension.class, TimeDimensionGrain.class, Table.class, Versioned.class, Namespace.class));
        this.enableMetaDataStore = enableMetaDataStore;
        modelsToBind.forEach(cls -> {
            String version = EntityDictionary.getModelVersion((Type)cls);
            HashMapDataStore hashMapDataStore = this.hashMapDataStores.computeIfAbsent(version, this.getHashMapDataStoreInitializer(entityDictionaryBuilderCustomizer));
            hashMapDataStore.getDictionary().bindEntity(cls, AggregationDataStore.IS_FIELD_HIDDEN);
            this.metadataDictionary.bindEntity(cls, AggregationDataStore.IS_FIELD_HIDDEN);
            this.hashMapDataStores.putIfAbsent(version, hashMapDataStore);
            Include include = (Include)EntityDictionary.getFirstPackageAnnotation((Type)cls, Arrays.asList(Include.class));
            if (include == null) {
                Pair registration = Pair.of((Object)"", (Object)version);
                this.namespacesToBind.put((Pair<String, String>)registration, new NamespacePackage("", "Default Namespace", "default", version));
            } else {
                Pair registration = Pair.of((Object)include.name(), (Object)version);
                this.namespacesToBind.put((Pair<String, String>)registration, new NamespacePackage(include.name(), include.description(), include.friendlyName(), version));
            }
        });
        this.modelsToBind = modelsToBind;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        if (this.enableMetaDataStore) {
            this.metadataModelClasses.forEach(cls -> dictionary.bindEntity(cls, AggregationDataStore.IS_FIELD_HIDDEN));
            this.metadataDictionary.getApiVersions().forEach(dictionary.getApiVersions()::add);
        }
    }

    private final Function<String, HashMapDataStore> getHashMapDataStoreInitializer(EntityDictionaryBuilderCustomizer entityDictionaryBuilderCustomizer) {
        return key -> {
            HashMapDataStore hashMapDataStore = new HashMapDataStore(this.metadataModelClasses);
            EntityDictionary.EntityDictionaryBuilder builder = EntityDictionary.builder();
            entityDictionaryBuilderCustomizer.customize(builder);
            EntityDictionary dictionary = builder.build();
            this.metadataModelClasses.forEach(arg_0 -> ((EntityDictionary)dictionary).bindEntity(arg_0));
            hashMapDataStore.populateEntityDictionary(dictionary);
            return hashMapDataStore;
        };
    }

    public void addTable(Table table) {
        String version = table.getVersion();
        EntityDictionary dictionary = this.hashMapDataStores.computeIfAbsent(version, SERVER_ERROR).getDictionary();
        this.tables.put(dictionary.getEntityClass(table.getName(), version), table);
        if (!table.isHidden()) {
            this.addMetaData(table, version);
        }
        table.getAllColumns().stream().forEach(this::addColumn);
        table.getArgumentDefinitions().forEach(arg -> this.addArgument((ArgumentDefinition)arg, version));
    }

    public void addNamespace(Namespace namespace) {
        String version = namespace.getVersion();
        this.namespaces.add(namespace);
        this.addMetaData(namespace, version);
    }

    public <T extends Table> T getTable(Type<?> tableClass) {
        return (T)this.tables.get(tableClass);
    }

    public Namespace getNamespace(Type<?> modelType) {
        String apiVersionName = EntityDictionary.getModelVersion(modelType);
        Include include = (Include)EntityDictionary.getFirstPackageAnnotation(modelType, Arrays.asList(Include.class));
        String namespaceName = include != null && !include.name().isEmpty() ? include.name() : "default";
        return this.namespaces.stream().filter(namespace -> namespace.getName().equals(namespaceName)).filter(namespace -> namespace.getVersion().equals(apiVersionName)).findFirst().orElse(null);
    }

    public Table getTable(String name, String version) {
        return this.tables.values().stream().filter(table -> table.getName().equals(name) && table.getVersion().equals(version)).findFirst().orElse(null);
    }

    public Set<Table> getTables() {
        return new HashSet<Table>(this.tables.values());
    }

    public final Column getColumn(Type<?> tableClass, String fieldName) {
        return ((Table)this.getTable(tableClass)).getColumnMap().get(fieldName);
    }

    public final Column getColumn(Path path) {
        Path.PathElement last = (Path.PathElement)path.lastElement().get();
        return this.getColumn(last.getType(), last.getFieldName());
    }

    public Set<NamespacePackage> getNamespacesToBind() {
        return new HashSet<NamespacePackage>(this.namespacesToBind.values());
    }

    private void addColumn(Column column) {
        String version = column.getVersion();
        if (!column.isHidden()) {
            this.addMetaData(column, version);
        }
        if (column instanceof TimeDimension) {
            TimeDimension timeDimension = (TimeDimension)column;
            for (TimeDimensionGrain grain : timeDimension.getSupportedGrains()) {
                this.addTimeDimensionGrain(grain, version);
            }
        }
        column.getArgumentDefinitions().forEach(arg -> this.addArgument((ArgumentDefinition)arg, version));
    }

    private void addArgument(ArgumentDefinition argument, String version) {
        this.addMetaData(argument, version);
    }

    private void addTimeDimensionGrain(TimeDimensionGrain timeDimensionGrain, String version) {
        this.addMetaData(timeDimensionGrain, version);
    }

    private void addMetaData(Object object, String version) {
        HashMapDataStore hashMapDataStore = this.hashMapDataStores.computeIfAbsent(version, SERVER_ERROR);
        EntityDictionary dictionary = hashMapDataStore.getDictionary();
        Type cls = dictionary.lookupBoundClass(EntityDictionary.getType((Object)object));
        String id = dictionary.getId(object);
        if (hashMapDataStore.get(cls).containsKey(id)) {
            if (!hashMapDataStore.get(cls).get(id).equals(object)) {
                throw new DuplicateMappingException("Duplicated " + cls.getSimpleName() + " metadata " + id);
            }
        } else {
            hashMapDataStore.get(cls).put(id, object);
        }
    }

    public <T> Set<T> getMetaData(Type<T> cls) {
        String version = EntityDictionary.getModelVersion(cls);
        HashMapDataStore hashMapDataStore = this.hashMapDataStores.computeIfAbsent(version, SERVER_ERROR);
        return hashMapDataStore.get(cls).values().stream().map(obj -> obj).collect(Collectors.toSet());
    }

    public static boolean isMetricField(EntityDictionary dictionary, Type<?> cls, String fieldName) {
        return dictionary.attributeOrRelationAnnotationExists(cls, fieldName, MetricFormula.class);
    }

    public DataStoreTransaction beginTransaction() {
        return new MetaDataStoreTransaction(this.hashMapDataStores);
    }

    @Generated
    public Set<Type<?>> getModelsToBind() {
        return this.modelsToBind;
    }

    @Generated
    public boolean isEnableMetaDataStore() {
        return this.enableMetaDataStore;
    }

    @Generated
    public EntityDictionary getMetadataDictionary() {
        return this.metadataDictionary;
    }

    @Generated
    public Map<String, HashMapDataStore> getHashMapDataStores() {
        return this.hashMapDataStores;
    }
}

