/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLJoin;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class PhysicalRefColumnContext
extends ColumnContext {
    private static final String HANDLEBAR_PREFIX = "{{";
    private static final String HANDLEBAR_SUFFIX = "}}";

    public PhysicalRefColumnContext(MetaDataStore metaDataStore, Queryable queryable, String alias, ColumnProjection column, Map<String, Argument> tableArguments) {
        super(metaDataStore, queryable, alias, column, tableArguments);
    }

    @Override
    protected ColumnContext getNewContext(ColumnContext context, ColumnProjection newColumn) {
        return PhysicalRefColumnContext.physicalRefContextBuilder().queryable(context.getQueryable()).alias(context.getAlias()).metaDataStore(context.getMetaDataStore()).column(newColumn).tableArguments(context.getTableArguments()).build();
    }

    @Override
    protected ColumnContext getJoinContext(String key) {
        SQLJoin sqlJoin = this.queryable.getJoin(key);
        Queryable joinQueryable = (Queryable)this.metaDataStore.getTable(sqlJoin.getJoinTableType());
        String joinPath = StringUtils.isBlank((CharSequence)this.alias) ? key : this.alias + "." + key;
        PhysicalRefColumnContext joinCtx = PhysicalRefColumnContext.physicalRefContextBuilder().queryable(joinQueryable).alias(joinPath).metaDataStore(this.metaDataStore).column(this.column).tableArguments(PhysicalRefColumnContext.mergedArgumentMap(joinQueryable.getArguments(), this.getTableArguments())).build();
        return joinCtx;
    }

    @Override
    protected String resolvePhysicalReference(ColumnContext context, String keyStr) {
        return StringUtils.isBlank((CharSequence)context.getAlias()) ? HANDLEBAR_PREFIX + keyStr + HANDLEBAR_SUFFIX : HANDLEBAR_PREFIX + context.getAlias() + "." + keyStr + HANDLEBAR_SUFFIX;
    }

    @Generated
    public static PhysicalRefColumnContextBuilder physicalRefContextBuilder() {
        return new PhysicalRefColumnContextBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "PhysicalRefColumnContext()";
    }

    @Generated
    public static class PhysicalRefColumnContextBuilder {
        @Generated
        private MetaDataStore metaDataStore;
        @Generated
        private Queryable queryable;
        @Generated
        private String alias;
        @Generated
        private ColumnProjection column;
        @Generated
        private Map<String, Argument> tableArguments;

        @Generated
        PhysicalRefColumnContextBuilder() {
        }

        @Generated
        public PhysicalRefColumnContextBuilder metaDataStore(MetaDataStore metaDataStore) {
            this.metaDataStore = metaDataStore;
            return this;
        }

        @Generated
        public PhysicalRefColumnContextBuilder queryable(Queryable queryable) {
            this.queryable = queryable;
            return this;
        }

        @Generated
        public PhysicalRefColumnContextBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Generated
        public PhysicalRefColumnContextBuilder column(ColumnProjection column) {
            this.column = column;
            return this;
        }

        @Generated
        public PhysicalRefColumnContextBuilder tableArguments(Map<String, Argument> tableArguments) {
            this.tableArguments = tableArguments;
            return this;
        }

        @Generated
        public PhysicalRefColumnContext build() {
            return new PhysicalRefColumnContext(this.metaDataStore, this.queryable, this.alias, this.column, this.tableArguments);
        }

        @Generated
        public String toString() {
            return "PhysicalRefColumnContext.PhysicalRefColumnContextBuilder(metaDataStore=" + this.metaDataStore + ", queryable=" + this.queryable + ", alias=" + this.alias + ", column=" + this.column + ", tableArguments=" + this.tableArguments + ")";
        }
    }
}

