/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueSourceType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.TableSource;
import com.yahoo.elide.modelconfig.model.Named;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Include(rootLevel=false, name="argument")
public class ArgumentDefinition
implements Named {
    @Id
    private String id;
    private String name;
    private String description;
    private ValueType type;
    private final ValueSourceType valueSourceType;
    private Set<String> values;
    @OneToOne
    private TableSource tableSource;
    @Exclude
    private com.yahoo.elide.datastores.aggregation.annotation.TableSource tableSourceDefinition;
    private Object defaultValue;

    public boolean isRequired() {
        return this.defaultValue == null || this.defaultValue.toString().equals("");
    }

    public ArgumentDefinition(String idPrefix, com.yahoo.elide.datastores.aggregation.annotation.ArgumentDefinition argument) {
        this.id = idPrefix + "." + argument.name();
        this.name = argument.name();
        this.description = argument.description();
        this.type = argument.type();
        this.values = new HashSet<String>(Arrays.asList(argument.values()));
        this.tableSourceDefinition = argument.tableSource();
        this.defaultValue = argument.defaultValue();
        this.valueSourceType = ValueSourceType.getValueSourceType(this.values, this.tableSourceDefinition);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ValueType getType() {
        return this.type;
    }

    @Generated
    public ValueSourceType getValueSourceType() {
        return this.valueSourceType;
    }

    @Generated
    public Set<String> getValues() {
        return this.values;
    }

    @Generated
    public TableSource getTableSource() {
        return this.tableSource;
    }

    @Generated
    public com.yahoo.elide.datastores.aggregation.annotation.TableSource getTableSourceDefinition() {
        return this.tableSourceDefinition;
    }

    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setType(ValueType type) {
        this.type = type;
    }

    @Generated
    public void setValues(Set<String> values) {
        this.values = values;
    }

    @Generated
    public void setTableSource(TableSource tableSource) {
        this.tableSource = tableSource;
    }

    @Generated
    public void setTableSourceDefinition(com.yahoo.elide.datastores.aggregation.annotation.TableSource tableSourceDefinition) {
        this.tableSourceDefinition = tableSourceDefinition;
    }

    @Generated
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgumentDefinition)) {
            return false;
        }
        ArgumentDefinition other = (ArgumentDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ValueType this$type = this.getType();
        ValueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ValueSourceType this$valueSourceType = this.getValueSourceType();
        ValueSourceType other$valueSourceType = other.getValueSourceType();
        if (this$valueSourceType == null ? other$valueSourceType != null : !((Object)((Object)this$valueSourceType)).equals((Object)other$valueSourceType)) {
            return false;
        }
        Set<String> this$values = this.getValues();
        Set<String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        TableSource this$tableSource = this.getTableSource();
        TableSource other$tableSource = other.getTableSource();
        if (this$tableSource == null ? other$tableSource != null : !((Object)this$tableSource).equals(other$tableSource)) {
            return false;
        }
        com.yahoo.elide.datastores.aggregation.annotation.TableSource this$tableSourceDefinition = this.getTableSourceDefinition();
        com.yahoo.elide.datastores.aggregation.annotation.TableSource other$tableSourceDefinition = other.getTableSourceDefinition();
        if (this$tableSourceDefinition == null ? other$tableSourceDefinition != null : !this$tableSourceDefinition.equals(other$tableSourceDefinition)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArgumentDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ValueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ValueSourceType $valueSourceType = this.getValueSourceType();
        result = result * 59 + ($valueSourceType == null ? 43 : ((Object)((Object)$valueSourceType)).hashCode());
        Set<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        TableSource $tableSource = this.getTableSource();
        result = result * 59 + ($tableSource == null ? 43 : ((Object)$tableSource).hashCode());
        com.yahoo.elide.datastores.aggregation.annotation.TableSource $tableSourceDefinition = this.getTableSourceDefinition();
        result = result * 59 + ($tableSourceDefinition == null ? 43 : $tableSourceDefinition.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArgumentDefinition(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", valueSourceType=" + this.getValueSourceType() + ", values=" + this.getValues() + ", tableSource=" + this.getTableSource() + ", tableSourceDefinition=" + this.getTableSourceDefinition() + ", defaultValue=" + this.getDefaultValue() + ")";
    }

    @Generated
    public ArgumentDefinition(String id, String name, String description, ValueType type, ValueSourceType valueSourceType, Set<String> values, TableSource tableSource, com.yahoo.elide.datastores.aggregation.annotation.TableSource tableSourceDefinition, Object defaultValue) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.valueSourceType = valueSourceType;
        this.values = values;
        this.tableSource = tableSource;
        this.tableSourceDefinition = tableSourceDefinition;
        this.defaultValue = defaultValue;
    }
}

