/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.annotation.MetricFormula;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.query.MetricProjectionMaker;
import lombok.Generated;

@Include(rootLevel=false, name="metric")
public class Metric
extends Column {
    @Exclude
    private final MetricProjectionMaker metricProjectionMaker;

    public Metric(MetricProjectionMaker maker, Table table, String fieldName, EntityDictionary dictionary) {
        super(table, fieldName, dictionary);
        this.metricProjectionMaker = maker;
    }

    public Metric(Table table, String fieldName, EntityDictionary dictionary) {
        super(table, fieldName, dictionary);
        Type tableClass = dictionary.getEntityClass(table.getName(), table.getVersion());
        MetricFormula formula = (MetricFormula)dictionary.getAttributeOrRelationAnnotation(tableClass, MetricFormula.class, fieldName);
        this.verifyFormula(formula);
        this.metricProjectionMaker = (MetricProjectionMaker)dictionary.getInjector().instantiate(formula.maker());
        dictionary.getInjector().inject((Object)this.metricProjectionMaker);
    }

    private void verifyFormula(MetricFormula formula) {
        Class defaultMaker;
        String defaultValue;
        if (formula == null) {
            throw new IllegalStateException("Trying to construct metric field " + this.getId() + " without @MetricFormula.");
        }
        try {
            defaultValue = (String)MetricFormula.class.getDeclaredMethod("value", new Class[0]).getDefaultValue();
            defaultMaker = (Class)MetricFormula.class.getDeclaredMethod("maker", new Class[0]).getDefaultValue();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("Error encountered while constructing metric field: " + this.getId() + ". " + e.getMessage());
        }
        if (formula.value().equals(defaultValue) && formula.maker().equals(defaultMaker)) {
            throw new IllegalStateException("Trying to construct metric field " + this.getId() + " with default values. Provide either value or maker in @MetricFormula.");
        }
        if (!formula.value().equals(defaultValue) && !formula.maker().equals(defaultMaker)) {
            throw new IllegalStateException("Trying to construct metric field " + this.getId() + " with value and maker. Provide either one in @MetricFormula, both are not allowed.");
        }
    }

    @Generated
    public MetricProjectionMaker getMetricProjectionMaker() {
        return this.metricProjectionMaker;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetricProjectionMaker this$metricProjectionMaker = this.getMetricProjectionMaker();
        MetricProjectionMaker other$metricProjectionMaker = other.getMetricProjectionMaker();
        return !(this$metricProjectionMaker == null ? other$metricProjectionMaker != null : !this$metricProjectionMaker.equals(other$metricProjectionMaker));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Metric;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MetricProjectionMaker $metricProjectionMaker = this.getMetricProjectionMaker();
        result = result * 59 + ($metricProjectionMaker == null ? 43 : $metricProjectionMaker.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Metric()";
    }
}

