/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.datastores.aggregation.annotation.TimeGrainDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import jakarta.persistence.Id;
import java.util.Locale;
import lombok.Generated;

@Include(rootLevel=false, name="timeDimensionGrain")
public final class TimeDimensionGrain {
    @Id
    private final String id;
    private final TimeGrain grain;
    private final String expression;
    private final String format;

    public TimeDimensionGrain(String fieldName, TimeGrainDefinition definition) {
        this.id = TimeDimensionGrain.getId(fieldName, definition.grain());
        this.grain = definition.grain();
        this.expression = definition.expression();
        this.format = definition.grain().getFormat();
    }

    public TimeDimensionGrain(String fieldName, TimeGrain grain) {
        this.id = TimeDimensionGrain.getId(fieldName, grain);
        this.grain = grain;
        this.expression = "{{$$column.expr}}";
        this.format = grain.getFormat();
    }

    private static String getId(String fieldName, TimeGrain grain) {
        return fieldName + "." + grain.name().toLowerCase(Locale.ENGLISH);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public TimeGrain getGrain() {
        return this.grain;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeDimensionGrain)) {
            return false;
        }
        TimeDimensionGrain other = (TimeDimensionGrain)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TimeGrain this$grain = this.getGrain();
        TimeGrain other$grain = other.getGrain();
        if (this$grain == null ? other$grain != null : !((Object)((Object)this$grain)).equals((Object)other$grain)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TimeGrain $grain = this.getGrain();
        result = result * 59 + ($grain == null ? 43 : ((Object)((Object)$grain)).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeDimensionGrain(id=" + this.getId() + ", grain=" + this.getGrain() + ", expression=" + this.getExpression() + ", format=" + this.getFormat() + ")";
    }
}

