/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.ImmutablePagination;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.QueryVisitor;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class Query
implements Queryable {
    @NonNull
    private final Queryable source;
    @NonNull
    private final List<MetricProjection> metricProjections;
    @NonNull
    private final List<DimensionProjection> dimensionProjections;
    @NonNull
    private final List<TimeDimensionProjection> timeDimensionProjections;
    private final FilterExpression whereFilter;
    private final FilterExpression havingFilter;
    private final Sorting sorting;
    private final ImmutablePagination pagination;
    private final Map<String, Argument> arguments;
    private final RequestScope scope;
    private final boolean bypassingCache;

    @Override
    public <T> T accept(QueryVisitor<T> visitor) {
        return visitor.visitQuery(this);
    }

    public List<ColumnProjection> getAllDimensionProjections() {
        return Stream.concat(this.getDimensionProjections().stream(), this.getTimeDimensionProjections().stream()).collect(Collectors.toCollection(ArrayList::new));
    }

    @Generated
    private static Map<String, Argument> $default$arguments() {
        return new HashMap<String, Argument>();
    }

    @Generated
    Query(@NonNull Queryable source, @NonNull List<MetricProjection> metricProjections, @NonNull List<DimensionProjection> dimensionProjections, @NonNull List<TimeDimensionProjection> timeDimensionProjections, FilterExpression whereFilter, FilterExpression havingFilter, Sorting sorting, ImmutablePagination pagination, Map<String, Argument> arguments, RequestScope scope, boolean bypassingCache) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (metricProjections == null) {
            throw new NullPointerException("metricProjections is marked non-null but is null");
        }
        if (dimensionProjections == null) {
            throw new NullPointerException("dimensionProjections is marked non-null but is null");
        }
        if (timeDimensionProjections == null) {
            throw new NullPointerException("timeDimensionProjections is marked non-null but is null");
        }
        this.source = source;
        this.metricProjections = metricProjections;
        this.dimensionProjections = dimensionProjections;
        this.timeDimensionProjections = timeDimensionProjections;
        this.whereFilter = whereFilter;
        this.havingFilter = havingFilter;
        this.sorting = sorting;
        this.pagination = pagination;
        this.arguments = arguments;
        this.scope = scope;
        this.bypassingCache = bypassingCache;
    }

    @Generated
    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    @Override
    @NonNull
    @Generated
    public Queryable getSource() {
        return this.source;
    }

    @Override
    @NonNull
    @Generated
    public List<MetricProjection> getMetricProjections() {
        return this.metricProjections;
    }

    @Override
    @NonNull
    @Generated
    public List<DimensionProjection> getDimensionProjections() {
        return this.dimensionProjections;
    }

    @Override
    @NonNull
    @Generated
    public List<TimeDimensionProjection> getTimeDimensionProjections() {
        return this.timeDimensionProjections;
    }

    @Override
    @Generated
    public FilterExpression getWhereFilter() {
        return this.whereFilter;
    }

    @Generated
    public FilterExpression getHavingFilter() {
        return this.havingFilter;
    }

    @Generated
    public Sorting getSorting() {
        return this.sorting;
    }

    @Generated
    public ImmutablePagination getPagination() {
        return this.pagination;
    }

    @Override
    @Generated
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @Generated
    public RequestScope getScope() {
        return this.scope;
    }

    @Generated
    public boolean isBypassingCache() {
        return this.bypassingCache;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        Queryable this$source = this.getSource();
        Queryable other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<MetricProjection> this$metricProjections = this.getMetricProjections();
        List<MetricProjection> other$metricProjections = other.getMetricProjections();
        if (this$metricProjections == null ? other$metricProjections != null : !((Object)this$metricProjections).equals(other$metricProjections)) {
            return false;
        }
        List<DimensionProjection> this$dimensionProjections = this.getDimensionProjections();
        List<DimensionProjection> other$dimensionProjections = other.getDimensionProjections();
        if (this$dimensionProjections == null ? other$dimensionProjections != null : !((Object)this$dimensionProjections).equals(other$dimensionProjections)) {
            return false;
        }
        List<TimeDimensionProjection> this$timeDimensionProjections = this.getTimeDimensionProjections();
        List<TimeDimensionProjection> other$timeDimensionProjections = other.getTimeDimensionProjections();
        if (this$timeDimensionProjections == null ? other$timeDimensionProjections != null : !((Object)this$timeDimensionProjections).equals(other$timeDimensionProjections)) {
            return false;
        }
        FilterExpression this$whereFilter = this.getWhereFilter();
        FilterExpression other$whereFilter = other.getWhereFilter();
        if (this$whereFilter == null ? other$whereFilter != null : !this$whereFilter.equals(other$whereFilter)) {
            return false;
        }
        FilterExpression this$havingFilter = this.getHavingFilter();
        FilterExpression other$havingFilter = other.getHavingFilter();
        if (this$havingFilter == null ? other$havingFilter != null : !this$havingFilter.equals(other$havingFilter)) {
            return false;
        }
        Sorting this$sorting = this.getSorting();
        Sorting other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !this$sorting.equals(other$sorting)) {
            return false;
        }
        ImmutablePagination this$pagination = this.getPagination();
        ImmutablePagination other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination)) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Queryable $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<MetricProjection> $metricProjections = this.getMetricProjections();
        result = result * 59 + ($metricProjections == null ? 43 : ((Object)$metricProjections).hashCode());
        List<DimensionProjection> $dimensionProjections = this.getDimensionProjections();
        result = result * 59 + ($dimensionProjections == null ? 43 : ((Object)$dimensionProjections).hashCode());
        List<TimeDimensionProjection> $timeDimensionProjections = this.getTimeDimensionProjections();
        result = result * 59 + ($timeDimensionProjections == null ? 43 : ((Object)$timeDimensionProjections).hashCode());
        FilterExpression $whereFilter = this.getWhereFilter();
        result = result * 59 + ($whereFilter == null ? 43 : $whereFilter.hashCode());
        FilterExpression $havingFilter = this.getHavingFilter();
        result = result * 59 + ($havingFilter == null ? 43 : $havingFilter.hashCode());
        Sorting $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : $sorting.hashCode());
        ImmutablePagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Query(source=" + this.getSource() + ", metricProjections=" + this.getMetricProjections() + ", dimensionProjections=" + this.getDimensionProjections() + ", timeDimensionProjections=" + this.getTimeDimensionProjections() + ", whereFilter=" + this.getWhereFilter() + ", havingFilter=" + this.getHavingFilter() + ", sorting=" + this.getSorting() + ", pagination=" + this.getPagination() + ", arguments=" + this.getArguments() + ", scope=" + this.getScope() + ", bypassingCache=" + this.isBypassingCache() + ")";
    }

    public static class QueryBuilder {
        @Generated
        private Queryable source;
        @Generated
        private ArrayList<MetricProjection> metricProjections;
        @Generated
        private ArrayList<DimensionProjection> dimensionProjections;
        @Generated
        private ArrayList<TimeDimensionProjection> timeDimensionProjections;
        @Generated
        private FilterExpression whereFilter;
        @Generated
        private FilterExpression havingFilter;
        @Generated
        private Sorting sorting;
        @Generated
        private ImmutablePagination pagination;
        @Generated
        private boolean arguments$set;
        @Generated
        private Map<String, Argument> arguments$value;
        @Generated
        private RequestScope scope;
        @Generated
        private boolean bypassingCache;

        public QueryBuilder column(ColumnProjection column) {
            if (column instanceof MetricProjection) {
                this.metricProjection((MetricProjection)column);
            } else if (column instanceof DimensionProjection) {
                this.dimensionProjection((DimensionProjection)column);
            } else {
                this.timeDimensionProjection((TimeDimensionProjection)column);
            }
            return this;
        }

        public QueryBuilder query(Query query) {
            this.source(query.getSource());
            this.metricProjections(query.getMetricProjections());
            this.dimensionProjections(query.getDimensionProjections());
            this.timeDimensionProjections(query.getTimeDimensionProjections());
            this.arguments(query.getArguments());
            this.sorting(query.getSorting());
            this.pagination(query.getPagination());
            this.whereFilter(query.getWhereFilter());
            this.havingFilter(query.getHavingFilter());
            this.bypassingCache(query.isBypassingCache());
            this.scope(query.getScope());
            return this;
        }

        @Generated
        QueryBuilder() {
        }

        @Generated
        public QueryBuilder source(@NonNull Queryable source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        @Generated
        public QueryBuilder metricProjection(MetricProjection metricProjection) {
            if (this.metricProjections == null) {
                this.metricProjections = new ArrayList();
            }
            this.metricProjections.add(metricProjection);
            return this;
        }

        @Generated
        public QueryBuilder metricProjections(Collection<? extends MetricProjection> metricProjections) {
            if (metricProjections == null) {
                throw new NullPointerException("metricProjections cannot be null");
            }
            if (this.metricProjections == null) {
                this.metricProjections = new ArrayList();
            }
            this.metricProjections.addAll(metricProjections);
            return this;
        }

        @Generated
        public QueryBuilder clearMetricProjections() {
            if (this.metricProjections != null) {
                this.metricProjections.clear();
            }
            return this;
        }

        @Generated
        public QueryBuilder dimensionProjection(DimensionProjection dimensionProjection) {
            if (this.dimensionProjections == null) {
                this.dimensionProjections = new ArrayList();
            }
            this.dimensionProjections.add(dimensionProjection);
            return this;
        }

        @Generated
        public QueryBuilder dimensionProjections(Collection<? extends DimensionProjection> dimensionProjections) {
            if (dimensionProjections == null) {
                throw new NullPointerException("dimensionProjections cannot be null");
            }
            if (this.dimensionProjections == null) {
                this.dimensionProjections = new ArrayList();
            }
            this.dimensionProjections.addAll(dimensionProjections);
            return this;
        }

        @Generated
        public QueryBuilder clearDimensionProjections() {
            if (this.dimensionProjections != null) {
                this.dimensionProjections.clear();
            }
            return this;
        }

        @Generated
        public QueryBuilder timeDimensionProjection(TimeDimensionProjection timeDimensionProjection) {
            if (this.timeDimensionProjections == null) {
                this.timeDimensionProjections = new ArrayList();
            }
            this.timeDimensionProjections.add(timeDimensionProjection);
            return this;
        }

        @Generated
        public QueryBuilder timeDimensionProjections(Collection<? extends TimeDimensionProjection> timeDimensionProjections) {
            if (timeDimensionProjections == null) {
                throw new NullPointerException("timeDimensionProjections cannot be null");
            }
            if (this.timeDimensionProjections == null) {
                this.timeDimensionProjections = new ArrayList();
            }
            this.timeDimensionProjections.addAll(timeDimensionProjections);
            return this;
        }

        @Generated
        public QueryBuilder clearTimeDimensionProjections() {
            if (this.timeDimensionProjections != null) {
                this.timeDimensionProjections.clear();
            }
            return this;
        }

        @Generated
        public QueryBuilder whereFilter(FilterExpression whereFilter) {
            this.whereFilter = whereFilter;
            return this;
        }

        @Generated
        public QueryBuilder havingFilter(FilterExpression havingFilter) {
            this.havingFilter = havingFilter;
            return this;
        }

        @Generated
        public QueryBuilder sorting(Sorting sorting) {
            this.sorting = sorting;
            return this;
        }

        @Generated
        public QueryBuilder pagination(ImmutablePagination pagination) {
            this.pagination = pagination;
            return this;
        }

        @Generated
        public QueryBuilder arguments(Map<String, Argument> arguments) {
            this.arguments$value = arguments;
            this.arguments$set = true;
            return this;
        }

        @Generated
        public QueryBuilder scope(RequestScope scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public QueryBuilder bypassingCache(boolean bypassingCache) {
            this.bypassingCache = bypassingCache;
            return this;
        }

        @Generated
        public Query build() {
            List<MetricProjection> metricProjections = switch (this.metricProjections == null ? 0 : this.metricProjections.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.metricProjections.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MetricProjection>(this.metricProjections));
            };
            List<DimensionProjection> dimensionProjections = switch (this.dimensionProjections == null ? 0 : this.dimensionProjections.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.dimensionProjections.get(0));
                default -> Collections.unmodifiableList(new ArrayList<DimensionProjection>(this.dimensionProjections));
            };
            List<TimeDimensionProjection> timeDimensionProjections = switch (this.timeDimensionProjections == null ? 0 : this.timeDimensionProjections.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.timeDimensionProjections.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TimeDimensionProjection>(this.timeDimensionProjections));
            };
            Map<String, Argument> arguments$value = this.arguments$value;
            if (!this.arguments$set) {
                arguments$value = Query.$default$arguments();
            }
            return new Query(this.source, metricProjections, dimensionProjections, timeDimensionProjections, this.whereFilter, this.havingFilter, this.sorting, this.pagination, arguments$value, this.scope, this.bypassingCache);
        }

        @Generated
        public String toString() {
            return "Query.QueryBuilder(source=" + this.source + ", metricProjections=" + this.metricProjections + ", dimensionProjections=" + this.dimensionProjections + ", timeDimensionProjections=" + this.timeDimensionProjections + ", whereFilter=" + this.whereFilter + ", havingFilter=" + this.havingFilter + ", sorting=" + this.sorting + ", pagination=" + this.pagination + ", arguments$value=" + this.arguments$value + ", scope=" + this.scope + ", bypassingCache=" + this.bypassingCache + ")";
        }
    }
}

