/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public class QueryPlan
implements Queryable {
    @NonNull
    private Queryable source;
    @NonNull
    private List<MetricProjection> metricProjections;
    @NonNull
    private List<DimensionProjection> dimensionProjections;
    @NonNull
    private List<TimeDimensionProjection> timeDimensionProjections;
    private FilterExpression whereFilter;

    public boolean canNest(MetaDataStore metaDataStore) {
        return this.getColumnProjections().stream().allMatch(projection -> projection.canNest(this.source, metaDataStore));
    }

    public QueryPlan nest(MetaDataStore metaDataStore) {
        if (!this.canNest(metaDataStore)) {
            throw new UnsupportedOperationException("Cannot nest this query plan");
        }
        Set nestedMetrics = this.metricProjections.stream().map(projection -> projection.nest(this.source, metaDataStore, false)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set nestedDimensions = this.dimensionProjections.stream().map(projection -> projection.nest(this.source, metaDataStore, false)).collect(Collectors.toCollection(LinkedHashSet::new));
        Set nestedTimeDimensions = this.timeDimensionProjections.stream().map(projection -> projection.nest(this.source, metaDataStore, false)).collect(Collectors.toCollection(LinkedHashSet::new));
        QueryPlan inner = QueryPlan.builder().source(this.getSource()).whereFilter(this.whereFilter).metricProjections(nestedMetrics.stream().map(Pair::getRight).flatMap(Collection::stream).map(MetricProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).dimensionProjections(nestedDimensions.stream().map(Pair::getRight).flatMap(Collection::stream).map(DimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).timeDimensionProjections(nestedTimeDimensions.stream().map(Pair::getRight).flatMap(Collection::stream).map(TimeDimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).build();
        return QueryPlan.builder().source(inner).metricProjections(nestedMetrics.stream().map(Pair::getLeft).map(MetricProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).dimensionProjections(nestedDimensions.stream().map(Pair::getLeft).map(DimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).timeDimensionProjections(nestedTimeDimensions.stream().map(Pair::getLeft).map(TimeDimensionProjection.class::cast).collect(Collectors.toCollection(LinkedHashSet::new))).build();
    }

    @Generated
    QueryPlan(@NonNull Queryable source, @NonNull List<MetricProjection> metricProjections, @NonNull List<DimensionProjection> dimensionProjections, @NonNull List<TimeDimensionProjection> timeDimensionProjections, FilterExpression whereFilter) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (metricProjections == null) {
            throw new NullPointerException("metricProjections is marked non-null but is null");
        }
        if (dimensionProjections == null) {
            throw new NullPointerException("dimensionProjections is marked non-null but is null");
        }
        if (timeDimensionProjections == null) {
            throw new NullPointerException("timeDimensionProjections is marked non-null but is null");
        }
        this.source = source;
        this.metricProjections = metricProjections;
        this.dimensionProjections = dimensionProjections;
        this.timeDimensionProjections = timeDimensionProjections;
        this.whereFilter = whereFilter;
    }

    @Generated
    public static QueryPlanBuilder builder() {
        return new QueryPlanBuilder();
    }

    @Override
    @NonNull
    @Generated
    public Queryable getSource() {
        return this.source;
    }

    @Override
    @NonNull
    @Generated
    public List<MetricProjection> getMetricProjections() {
        return this.metricProjections;
    }

    @Override
    @NonNull
    @Generated
    public List<DimensionProjection> getDimensionProjections() {
        return this.dimensionProjections;
    }

    @Override
    @NonNull
    @Generated
    public List<TimeDimensionProjection> getTimeDimensionProjections() {
        return this.timeDimensionProjections;
    }

    @Override
    @Generated
    public FilterExpression getWhereFilter() {
        return this.whereFilter;
    }

    @Generated
    public static class QueryPlanBuilder {
        @Generated
        private Queryable source;
        @Generated
        private ArrayList<MetricProjection> metricProjections;
        @Generated
        private ArrayList<DimensionProjection> dimensionProjections;
        @Generated
        private ArrayList<TimeDimensionProjection> timeDimensionProjections;
        @Generated
        private FilterExpression whereFilter;

        @Generated
        QueryPlanBuilder() {
        }

        @Generated
        public QueryPlanBuilder source(@NonNull Queryable source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        @Generated
        public QueryPlanBuilder metricProjection(MetricProjection metricProjection) {
            if (this.metricProjections == null) {
                this.metricProjections = new ArrayList();
            }
            this.metricProjections.add(metricProjection);
            return this;
        }

        @Generated
        public QueryPlanBuilder metricProjections(Collection<? extends MetricProjection> metricProjections) {
            if (metricProjections == null) {
                throw new NullPointerException("metricProjections cannot be null");
            }
            if (this.metricProjections == null) {
                this.metricProjections = new ArrayList();
            }
            this.metricProjections.addAll(metricProjections);
            return this;
        }

        @Generated
        public QueryPlanBuilder clearMetricProjections() {
            if (this.metricProjections != null) {
                this.metricProjections.clear();
            }
            return this;
        }

        @Generated
        public QueryPlanBuilder dimensionProjection(DimensionProjection dimensionProjection) {
            if (this.dimensionProjections == null) {
                this.dimensionProjections = new ArrayList();
            }
            this.dimensionProjections.add(dimensionProjection);
            return this;
        }

        @Generated
        public QueryPlanBuilder dimensionProjections(Collection<? extends DimensionProjection> dimensionProjections) {
            if (dimensionProjections == null) {
                throw new NullPointerException("dimensionProjections cannot be null");
            }
            if (this.dimensionProjections == null) {
                this.dimensionProjections = new ArrayList();
            }
            this.dimensionProjections.addAll(dimensionProjections);
            return this;
        }

        @Generated
        public QueryPlanBuilder clearDimensionProjections() {
            if (this.dimensionProjections != null) {
                this.dimensionProjections.clear();
            }
            return this;
        }

        @Generated
        public QueryPlanBuilder timeDimensionProjection(TimeDimensionProjection timeDimensionProjection) {
            if (this.timeDimensionProjections == null) {
                this.timeDimensionProjections = new ArrayList();
            }
            this.timeDimensionProjections.add(timeDimensionProjection);
            return this;
        }

        @Generated
        public QueryPlanBuilder timeDimensionProjections(Collection<? extends TimeDimensionProjection> timeDimensionProjections) {
            if (timeDimensionProjections == null) {
                throw new NullPointerException("timeDimensionProjections cannot be null");
            }
            if (this.timeDimensionProjections == null) {
                this.timeDimensionProjections = new ArrayList();
            }
            this.timeDimensionProjections.addAll(timeDimensionProjections);
            return this;
        }

        @Generated
        public QueryPlanBuilder clearTimeDimensionProjections() {
            if (this.timeDimensionProjections != null) {
                this.timeDimensionProjections.clear();
            }
            return this;
        }

        @Generated
        public QueryPlanBuilder whereFilter(FilterExpression whereFilter) {
            this.whereFilter = whereFilter;
            return this;
        }

        @Generated
        public QueryPlan build() {
            return new QueryPlan(this.source, switch (this.metricProjections == null ? 0 : this.metricProjections.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.metricProjections.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MetricProjection>(this.metricProjections));
            }, switch (this.dimensionProjections == null ? 0 : this.dimensionProjections.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.dimensionProjections.get(0));
                default -> Collections.unmodifiableList(new ArrayList<DimensionProjection>(this.dimensionProjections));
            }, switch (this.timeDimensionProjections == null ? 0 : this.timeDimensionProjections.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.timeDimensionProjections.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TimeDimensionProjection>(this.timeDimensionProjections));
            }, this.whereFilter);
        }

        @Generated
        public String toString() {
            return "QueryPlan.QueryPlanBuilder(source=" + this.source + ", metricProjections=" + this.metricProjections + ", dimensionProjections=" + this.dimensionProjections + ", timeDimensionProjections=" + this.timeDimensionProjections + ", whereFilter=" + this.whereFilter + ")";
        }
    }
}

