/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class NamedParamPreparedStatement {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("(?<!')(:[\\w]+_[0-9A-Fa-f]+_[\\d]+)(?!')");
    private PreparedStatement preparedStatement;
    private List<String> fields = new ArrayList<String>();

    public NamedParamPreparedStatement(Connection conn, String namedParamQuery) throws SQLException {
        Matcher matcher = PARAMETER_PATTERN.matcher(namedParamQuery);
        while (matcher.find()) {
            this.fields.add(matcher.group().substring(1));
        }
        this.preparedStatement = conn.prepareStatement(namedParamQuery.replaceAll(PARAMETER_PATTERN.pattern(), "?"));
    }

    public ResultSet executeQuery() throws SQLException {
        return this.preparedStatement.executeQuery();
    }

    public void close() throws SQLException {
        this.preparedStatement.close();
    }

    public void cancel() throws SQLException {
        this.preparedStatement.cancel();
    }

    public boolean isClosed() throws SQLException {
        return this.preparedStatement.isClosed();
    }

    public void setObject(String paramName, Object paramValue) throws SQLException {
        this.preparedStatement.setObject(this.getIndex(paramName), paramValue);
    }

    private int getIndex(String paramName) {
        return this.fields.indexOf(paramName) + 1;
    }

    @Generated
    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }
}

