/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TimedFunction;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.datastores.aggregation.DefaultQueryValidator;
import com.yahoo.elide.datastores.aggregation.QueryEngine;
import com.yahoo.elide.datastores.aggregation.QueryValidator;
import com.yahoo.elide.datastores.aggregation.dynamic.NamespacePackage;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.FormulaValidator;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Metric;
import com.yahoo.elide.datastores.aggregation.metadata.models.Namespace;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DefaultQueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.ImmutablePagination;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.Optimizer;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.QueryPlan;
import com.yahoo.elide.datastores.aggregation.query.QueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.QueryResult;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.ConnectionDetails;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.EntityHydrator;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.NamedParamPreparedStatement;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.VersionQuery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.NativeQuery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.QueryPlanTranslator;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.QueryTranslator;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLTimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import com.yahoo.elide.datastores.aggregation.validator.ColumnArgumentValidator;
import com.yahoo.elide.datastores.aggregation.validator.TableArgumentValidator;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLQueryEngine
extends QueryEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLQueryEngine.class);
    private final Set<Optimizer> optimizers;
    private final QueryValidator validator;
    private final FormulaValidator formulaValidator;
    private final Function<String, ConnectionDetails> connectionDetailsLookup;
    private final QueryPlanMerger merger;
    private static final Function<ResultSet, Object> SINGLE_RESULT_MAPPER = rs -> {
        try {
            if (rs.next()) {
                return rs.getObject(1);
            }
            return null;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    };

    public SQLQueryEngine(MetaDataStore metaDataStore, Function<String, ConnectionDetails> connectionDetailsLookup) {
        this(metaDataStore, connectionDetailsLookup, new HashSet<Optimizer>(), new DefaultQueryPlanMerger(metaDataStore), new DefaultQueryValidator(metaDataStore.getMetadataDictionary()));
    }

    public SQLQueryEngine(MetaDataStore metaDataStore, Function<String, ConnectionDetails> connectionDetailsLookup, Set<Optimizer> optimizers, QueryPlanMerger merger, QueryValidator validator) {
        Preconditions.checkNotNull(connectionDetailsLookup);
        this.connectionDetailsLookup = connectionDetailsLookup;
        this.metaDataStore = metaDataStore;
        this.validator = validator;
        this.formulaValidator = new FormulaValidator(metaDataStore);
        this.metadataDictionary = metaDataStore.getMetadataDictionary();
        this.populateMetaData(metaDataStore);
        this.optimizers = optimizers;
        this.merger = merger;
    }

    @Override
    protected Namespace constructNamespace(NamespacePackage namespacePackage) {
        return new Namespace(namespacePackage);
    }

    @Override
    protected Table constructTable(Namespace namespace, Type<?> entityClass, EntityDictionary metaDataDictionary) {
        String dbConnectionName = null;
        Annotation annotation = EntityDictionary.getFirstAnnotation(entityClass, Arrays.asList(FromTable.class, FromSubquery.class));
        if (annotation instanceof FromTable) {
            dbConnectionName = ((FromTable)annotation).dbConnectionName();
        } else if (annotation instanceof FromSubquery) {
            dbConnectionName = ((FromSubquery)annotation).dbConnectionName();
        }
        ConnectionDetails connectionDetails = this.connectionDetailsLookup.apply(dbConnectionName);
        return new SQLTable(namespace, entityClass, metaDataDictionary, connectionDetails);
    }

    @Override
    public DimensionProjection constructDimensionProjection(Dimension dimension, String alias, Map<String, Argument> arguments) {
        return new SQLDimensionProjection(dimension, alias, arguments, true);
    }

    @Override
    public TimeDimensionProjection constructTimeDimensionProjection(TimeDimension dimension, String alias, Map<String, Argument> arguments) {
        return new SQLTimeDimensionProjection(dimension, dimension.getTimezone(), alias, arguments, true);
    }

    @Override
    public MetricProjection constructMetricProjection(Metric metric, String alias, Map<String, Argument> arguments) {
        return metric.getMetricProjectionMaker().make(metric, alias, arguments);
    }

    @Override
    protected void verifyMetaData(MetaDataStore metaDataStore) {
        metaDataStore.getTables().forEach(table -> {
            SQLTable sqlTable = (SQLTable)table;
            this.checkForCycles(sqlTable);
            TableArgumentValidator tableArgValidator = new TableArgumentValidator(metaDataStore, sqlTable);
            tableArgValidator.validate();
            sqlTable.getAllColumns().forEach(column -> {
                ColumnArgumentValidator colArgValidator = new ColumnArgumentValidator(metaDataStore, sqlTable, (Column)column);
                colArgValidator.validate();
            });
        });
    }

    private void checkForCycles(SQLTable sqlTable) {
        sqlTable.getColumnProjections().forEach(column -> this.formulaValidator.parse((Queryable)sqlTable, (ColumnProjection)column));
    }

    @Override
    public QueryEngine.Transaction beginTransaction() {
        return new SqlTransaction();
    }

    @Override
    public QueryResult executeQuery(Query query, QueryEngine.Transaction transaction) {
        SqlTransaction sqlTransaction = (SqlTransaction)transaction;
        ConnectionDetails details = query.getConnectionDetails();
        DataSource dataSource = details.getDataSource();
        SQLDialect dialect = details.getDialect();
        Query expandedQuery = this.expandMetricQueryPlans(query);
        NativeQuery sql = this.toSQL(expandedQuery, dialect);
        String queryString = sql.toString();
        QueryResult.QueryResultBuilder<Object> resultBuilder = QueryResult.builder();
        ImmutablePagination pagination = query.getPagination();
        if (SQLQueryEngine.returnPageTotals(pagination)) {
            resultBuilder.pageTotals(this.getPageTotal(expandedQuery, sql, query, sqlTransaction));
        }
        log.debug("SQL Query: " + queryString);
        NamedParamPreparedStatement stmt = sqlTransaction.initializeStatement(queryString, dataSource);
        this.supplyFilterQueryParameters(query, stmt, dialect);
        ResultSet resultSet = (ResultSet)this.runQuery(stmt, queryString, Function.identity());
        resultBuilder.data(new EntityHydrator(resultSet, query, this.metadataDictionary));
        return resultBuilder.build();
    }

    private long getPageTotal(Query expandedQuery, NativeQuery sql, Query clientQuery, SqlTransaction sqlTransaction) {
        ConnectionDetails details = expandedQuery.getConnectionDetails();
        DataSource dataSource = details.getDataSource();
        SQLDialect dialect = details.getDialect();
        NativeQuery paginationSQL = this.toPageTotalSQL(expandedQuery, sql, dialect);
        if (paginationSQL == null) {
            return 1L;
        }
        NamedParamPreparedStatement stmt = sqlTransaction.initializeStatement(paginationSQL.toString(), dataSource);
        this.supplyFilterQueryParameters(clientQuery, stmt, dialect);
        Long result = (Long)CoerceUtil.coerce((Object)this.runQuery(stmt, paginationSQL.toString(), SINGLE_RESULT_MAPPER), Long.class);
        return result != null ? result : 0L;
    }

    @Override
    public String getTableVersion(Table table, QueryEngine.Transaction transaction) {
        String tableVersion = null;
        SQLTable sqlTable = (SQLTable)table;
        Type tableClass = this.metadataDictionary.getEntityClass(table.getName(), table.getVersion());
        VersionQuery versionAnnotation = (VersionQuery)tableClass.getAnnotation(VersionQuery.class);
        if (versionAnnotation != null) {
            String versionQueryString = versionAnnotation.sql();
            SqlTransaction sqlTransaction = (SqlTransaction)transaction;
            ConnectionDetails details = sqlTable.getConnectionDetails();
            DataSource dataSource = details.getDataSource();
            NamedParamPreparedStatement stmt = sqlTransaction.initializeStatement(versionQueryString, dataSource);
            tableVersion = (String)CoerceUtil.coerce((Object)this.runQuery(stmt, versionQueryString, SINGLE_RESULT_MAPPER), String.class);
        }
        return tableVersion;
    }

    private <R> R runQuery(NamedParamPreparedStatement stmt, String queryString, Function<ResultSet, R> resultMapper) {
        return (R)new TimedFunction(() -> {
            try {
                ResultSet rs = stmt.executeQuery();
                return resultMapper.apply(rs);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }, "Running Query: " + queryString).get();
    }

    public List<String> explain(Query query, SQLDialect dialect) {
        NativeQuery paginationSql;
        ArrayList<String> queries = new ArrayList<String>();
        Query expandedQuery = this.expandMetricQueryPlans(query);
        NativeQuery sql = this.toSQL(expandedQuery, dialect);
        ImmutablePagination pagination = query.getPagination();
        if (SQLQueryEngine.returnPageTotals(pagination) && (paginationSql = this.toPageTotalSQL(expandedQuery, sql, dialect)) != null) {
            queries.add(paginationSql.toString());
        }
        queries.add(sql.toString());
        return queries;
    }

    @Override
    public List<String> explain(Query query) {
        return this.explain(query, query.getConnectionDetails().getDialect());
    }

    @Override
    public QueryValidator getValidator() {
        return this.validator;
    }

    private NativeQuery toSQL(Query query, SQLDialect sqlDialect) {
        QueryTranslator translator = new QueryTranslator(this.metaDataStore, sqlDialect, query);
        return query.accept(translator).build();
    }

    private Query expandMetricQueryPlans(Query query) {
        List<QueryPlan> toMerge = query.getMetricProjections().stream().map(projection -> projection.resolve(query)).collect(Collectors.toList());
        List<QueryPlan> mergedPlans = this.merger.merge(toMerge);
        if (mergedPlans.size() != 1) {
            throw new UnsupportedOperationException("Incompatible metrics in client query.  Cannot merge into a single query");
        }
        QueryPlan mergedPlan = mergedPlans.get(0);
        QueryPlanTranslator queryPlanTranslator = new QueryPlanTranslator(query, this.metaDataStore, this.merger);
        Query merged = mergedPlan == null ? QueryPlanTranslator.addHiddenProjections(this.metaDataStore, query).build() : queryPlanTranslator.translate(mergedPlan);
        for (Optimizer optimizer : this.optimizers) {
            SQLTable table = (SQLTable)query.getSource();
            if (table.getHints().contains(optimizer.negateHint()) || !table.getHints().contains(optimizer.hint()) || !optimizer.canOptimize(merged)) continue;
            merged = optimizer.optimize(merged);
        }
        return merged;
    }

    private void supplyFilterQueryParameters(Query query, NamedParamPreparedStatement stmt, SQLDialect dialect) {
        ArrayList predicates = new ArrayList();
        if (query.getWhereFilter() != null) {
            predicates.addAll((Collection)query.getWhereFilter().accept((FilterExpressionVisitor)new PredicateExtractionVisitor()));
        }
        if (query.getHavingFilter() != null) {
            predicates.addAll((Collection)query.getHavingFilter().accept((FilterExpressionVisitor)new PredicateExtractionVisitor()));
        }
        for (FilterPredicate filterPredicate : predicates) {
            Column column = this.metaDataStore.getColumn(filterPredicate.getEntityType(), filterPredicate.getField());
            if (!filterPredicate.getOperator().isParameterized()) continue;
            boolean shouldEscape = filterPredicate.isMatchingOperator();
            filterPredicate.getParameters().forEach(param -> {
                try {
                    Object value = param.getValue();
                    value = this.convertForJdbc(filterPredicate.getEntityType(), column, value, dialect);
                    stmt.setObject(param.getName(), shouldEscape ? param.escapeMatching() : value);
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }

    private Object convertForJdbc(Type<?> parent, Column column, Object value, SQLDialect dialect) {
        Enumerated enumerated;
        if (column.getValueType().equals((Object)ValueType.TIME) && Time.class.isAssignableFrom(value.getClass())) {
            return dialect.translateTimeToJDBC((Time)value);
        }
        if (value.getClass().isEnum()) {
            Enumerated enumerated2 = (Enumerated)this.metadataDictionary.getAttributeOrRelationAnnotation(parent, Enumerated.class, column.getName());
            if (enumerated2 != null && enumerated2.value().equals((Object)EnumType.ORDINAL)) {
                return ((Enum)value).ordinal();
            }
            return value.toString();
        }
        if (column.getValueType().equals((Object)ValueType.TEXT) && column.getValues() != null && !column.getValues().isEmpty() && (enumerated = (Enumerated)this.metadataDictionary.getAttributeOrRelationAnnotation(parent, Enumerated.class, column.getName())) != null && enumerated.value().equals((Object)EnumType.ORDINAL)) {
            String[] enumValues = column.getValues().toArray(new String[0]);
            for (int idx = 0; idx < column.getValues().size(); ++idx) {
                if (!enumValues[idx].equals(value)) continue;
                return idx;
            }
            throw new IllegalStateException(String.format("Invalid value %s for column %s", value, column.getName()));
        }
        return value;
    }

    private NativeQuery toPageTotalSQL(Query query, NativeQuery sql, SQLDialect sqlDialect) {
        String groupByDimensions = query.getAllDimensionProjections().stream().map(SQLColumnProjection.class::cast).filter(ColumnProjection::isProjected).map(column -> column.toSQL(query, this.metaDataStore)).collect(Collectors.joining(", "));
        if (groupByDimensions.isEmpty()) {
            return null;
        }
        NativeQuery innerQuery = NativeQuery.builder().projectionClause(groupByDimensions).fromClause(sql.getFromClause()).joinClause(sql.getJoinClause()).whereClause(sql.getWhereClause()).groupByClause(String.format("GROUP BY %s", groupByDimensions)).havingClause(sql.getHavingClause()).build();
        return NativeQuery.builder().projectionClause("COUNT(*)").fromClause(QueryTranslator.getFromClause("(" + innerQuery + ")", ColumnContext.applyQuotes("pagination_subquery", sqlDialect), sqlDialect)).build();
    }

    private static boolean returnPageTotals(Pagination pagination) {
        return pagination != null && pagination.returnPageTotals();
    }

    private static void cancelSoftly(NamedParamPreparedStatement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.cancel();
            }
        }
        catch (SQLException e) {
            log.error("Exception encountered during cancel statement.", (Throwable)e);
        }
    }

    private static void cancelAndCloseSoftly(NamedParamPreparedStatement stmt) {
        SQLQueryEngine.cancelSoftly(stmt);
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            log.error("Exception encountered during close statement.", (Throwable)e);
        }
    }

    private static void closeSoftly(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("Exception encountered during close connection.", (Throwable)e);
        }
    }

    @Generated
    public Set<Optimizer> getOptimizers() {
        return this.optimizers;
    }

    static class SqlTransaction
    implements QueryEngine.Transaction {
        private Connection conn;
        private final List<NamedParamPreparedStatement> stmts = new ArrayList<NamedParamPreparedStatement>();

        SqlTransaction() {
        }

        private void initializeConnection(DataSource dataSource) {
            try {
                this.conn = dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }

        public NamedParamPreparedStatement initializeStatement(String namedParamQuery, DataSource dataSource) {
            NamedParamPreparedStatement stmt;
            try {
                if (this.conn == null || !this.conn.isValid(10)) {
                    this.initializeConnection(dataSource);
                }
                stmt = new NamedParamPreparedStatement(this.conn, namedParamQuery);
                this.stmts.add(stmt);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
            return stmt;
        }

        @Override
        public void close() {
            this.stmts.forEach(SQLQueryEngine::cancelAndCloseSoftly);
            SQLQueryEngine.closeSoftly(this.conn);
        }

        @Override
        public void cancel() {
            this.stmts.forEach(SQLQueryEngine::cancelSoftly);
        }
    }
}

