/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import java.util.Map;
import lombok.Generated;

public class SQLPhysicalColumnProjection
implements SQLColumnProjection,
DimensionProjection {
    private String name;

    public SQLPhysicalColumnProjection(String name) {
        if (name.indexOf(36) == 0) {
            name = name.substring(1);
        }
        this.name = name;
    }

    @Override
    public String toSQL(Queryable query, MetaDataStore metaDataStore) {
        SQLDialect dialect = query.getConnectionDetails().getDialect();
        return TypeHelper.getFieldAlias((String)ColumnContext.applyQuotes(query.getSource().getAlias(), dialect), (String)ColumnContext.applyQuotes(this.name, dialect));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpression() {
        return null;
    }

    @Override
    public ValueType getValueType() {
        return null;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.FIELD;
    }

    public SQLPhysicalColumnProjection withProjected(boolean projected) {
        return new SQLPhysicalColumnProjection(this.name);
    }

    public SQLPhysicalColumnProjection withExpression(String expression, boolean projected) {
        return new SQLPhysicalColumnProjection(this.name);
    }

    @Override
    public ColumnProjection withArguments(Map<String, Argument> arguments) {
        return new SQLPhysicalColumnProjection(this.name);
    }

    @Generated
    public static SQLPhysicalColumnProjectionBuilder builder() {
        return new SQLPhysicalColumnProjectionBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLPhysicalColumnProjection)) {
            return false;
        }
        SQLPhysicalColumnProjection other = (SQLPhysicalColumnProjection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLPhysicalColumnProjection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public static class SQLPhysicalColumnProjectionBuilder {
        @Generated
        private String name;

        @Generated
        SQLPhysicalColumnProjectionBuilder() {
        }

        @Generated
        public SQLPhysicalColumnProjectionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SQLPhysicalColumnProjection build() {
            return new SQLPhysicalColumnProjection(this.name);
        }

        @Generated
        public String toString() {
            return "SQLPhysicalColumnProjection.SQLPhysicalColumnProjectionBuilder(name=" + this.name + ")";
        }
    }
}

