/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore;

import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.annotations.JPQLFilterFragment;
import com.yahoo.elide.core.filter.FilterTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JPQLDataStore
extends DataStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(JPQLDataStore.class);

    default public void bindEntityClass(Class<?> entityClass, EntityDictionary dictionary) {
        try {
            dictionary.lookupEntityClass(entityClass);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        dictionary.bindEntity(entityClass);
        dictionary.getAttributes(entityClass).stream().forEach(attribute -> {
            JPQLFilterFragment annotation = (JPQLFilterFragment)dictionary.getAttributeOrRelationAnnotation(entityClass, JPQLFilterFragment.class, attribute);
            if (annotation != null) {
                try {
                    FilterTranslator.registerJPQLGenerator(annotation.operator(), entityClass, attribute, annotation.generator().newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error("Unable to instantiate the JPQL fragment generator: {}", (Object)e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

