/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHQLQueryBuilder {
    protected final Session session;
    protected final EntityDictionary dictionary;
    protected Optional<Sorting> sorting;
    protected Optional<Pagination> pagination;
    protected Optional<FilterExpression> filterExpression;
    protected static final String SPACE = " ";
    protected static final String UNDERSCORE = "_";
    protected static final String PERIOD = ".";
    protected static final String COMMA = ",";
    protected static final String FROM = " FROM ";
    protected static final String JOIN = " JOIN ";
    protected static final String LEFT = " LEFT";
    protected static final String FETCH = "FETCH ";
    protected static final String SELECT = "SELECT ";
    protected static final String AS = " AS ";
    protected static final String DISTINCT = "DISTINCT ";
    protected static final boolean USE_ALIAS = true;
    protected static final boolean NO_ALIAS = false;
    protected Set<String> alreadyJoined = new HashSet<String>();
    protected Set<String> alreadyJoinedAliases = new HashSet<String>();

    public AbstractHQLQueryBuilder(EntityDictionary dictionary, Session session) {
        this.session = session;
        this.dictionary = dictionary;
        this.sorting = Optional.empty();
        this.pagination = Optional.empty();
        this.filterExpression = Optional.empty();
    }

    public abstract Query build();

    public AbstractHQLQueryBuilder withPossibleFilterExpression(Optional<FilterExpression> filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public AbstractHQLQueryBuilder withPossibleSorting(Optional<Sorting> possibleSorting) {
        this.sorting = possibleSorting;
        return this;
    }

    public AbstractHQLQueryBuilder withPossiblePagination(Optional<Pagination> possiblePagination) {
        this.pagination = possiblePagination;
        return this;
    }

    protected void supplyFilterQueryParameters(Query query, Collection<FilterPredicate> predicates) {
        for (FilterPredicate filterPredicate : predicates) {
            if (!filterPredicate.getOperator().isParameterized()) continue;
            boolean shouldEscape = filterPredicate.isMatchingOperator();
            filterPredicate.getParameters().forEach(param -> query.setParameter(param.getName(), shouldEscape ? param.escapeMatching() : param.getValue()));
        }
    }

    protected String getJoinClauseFromFilters(FilterExpression filterExpression) {
        return this.getJoinClauseFromFilters(filterExpression, false);
    }

    protected String getJoinClauseFromFilters(FilterExpression filterExpression, boolean skipFetches) {
        PredicateExtractionVisitor visitor = new PredicateExtractionVisitor(new ArrayList());
        Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)visitor);
        return predicates.stream().map(predicate -> this.extractJoinClause((FilterPredicate)predicate, skipFetches)).collect(Collectors.joining(SPACE));
    }

    protected void addPaginationToQuery(Query query) {
        if (this.pagination.isPresent()) {
            Pagination pagination = this.pagination.get();
            query.setFirstResult(pagination.getOffset());
            query.setMaxResults(pagination.getLimit());
        }
    }

    private String extractJoinClause(FilterPredicate predicate, boolean skipFetches) {
        Path path = predicate.getPath();
        return this.joinClauseFromPath(path, skipFetches);
    }

    private String joinClauseFromPath(Path path, boolean skipFetches) {
        StringBuilder joinClause = new StringBuilder();
        String previousAlias = null;
        for (Path.PathElement pathElement : path.getPathElements()) {
            String fieldName = pathElement.getFieldName();
            Class typeClass = this.dictionary.lookupEntityClass(pathElement.getType());
            String typeAlias = FilterPredicate.getTypeAlias((Class)typeClass);
            if (!this.dictionary.isRelation(pathElement.getType(), fieldName)) {
                return joinClause.toString();
            }
            String alias = typeAlias + UNDERSCORE + fieldName;
            String joinKey = previousAlias == null ? typeAlias + PERIOD + fieldName : previousAlias + PERIOD + fieldName;
            String fetch = "";
            RelationshipType type = this.dictionary.getRelationshipType(pathElement.getType(), fieldName);
            if (!skipFetches && type.isToOne() && !type.isComputed() && previousAlias == null) {
                fetch = FETCH;
            }
            String joinFragment = " LEFT JOIN " + fetch + joinKey + SPACE + alias + SPACE;
            if (!this.alreadyJoined.contains(joinKey)) {
                joinClause.append(joinFragment);
                this.alreadyJoined.add(joinKey);
                this.alreadyJoinedAliases.add(alias);
            }
            previousAlias = alias;
        }
        return joinClause.toString();
    }

    protected String extractToOneMergeJoins(Class<?> entityClass, String alias) {
        return this.extractToOneMergeJoins(entityClass, alias, unused -> false);
    }

    protected String extractToOneMergeJoins(Class<?> entityClass, String alias, Function<String, Boolean> skipRelation) {
        List relationshipNames = this.dictionary.getRelationships(entityClass);
        StringBuilder joinString = new StringBuilder("");
        for (String relationshipName : relationshipNames) {
            RelationshipType type = this.dictionary.getRelationshipType(entityClass, relationshipName);
            if (!type.isToOne() || type.isComputed() || skipRelation.apply(relationshipName).booleanValue()) continue;
            String joinKey = alias + PERIOD + relationshipName;
            String relationshipAlias = alias + UNDERSCORE + relationshipName;
            if (this.alreadyJoined.contains(joinKey)) continue;
            this.alreadyJoined.add(joinKey);
            this.alreadyJoinedAliases.add(relationshipAlias);
            joinString.append(LEFT);
            joinString.append(JOIN);
            joinString.append(FETCH);
            joinString.append(joinKey);
            joinString.append(SPACE);
            joinString.append(relationshipAlias);
            joinString.append(SPACE);
        }
        return joinString.toString();
    }

    protected String explicitSortJoins(Optional<Sorting> sorting, Class<?> sortClass) {
        StringBuilder joinClause = new StringBuilder();
        if (sorting.isPresent() && !sorting.get().isDefaultInstance()) {
            Map validSortingRules = sorting.get().getValidSortingRules(sortClass, this.dictionary);
            for (Map.Entry entry : validSortingRules.entrySet()) {
                Path path = (Path)entry.getKey();
                joinClause.append(this.joinClauseFromPath(path, true));
            }
        }
        return joinClause.toString();
    }

    protected String getSortClause(Optional<Sorting> sorting, Class<?> sortClass, boolean prefixWithAlias) {
        Map validSortingRules;
        String sortingRules = "";
        if (sorting.isPresent() && !sorting.get().isDefaultInstance() && !(validSortingRules = sorting.get().getValidSortingRules(sortClass, this.dictionary)).isEmpty()) {
            ArrayList ordering = new ArrayList();
            validSortingRules.entrySet().stream().forEachOrdered(entry -> {
                String orderElement;
                Path path = (Path)entry.getKey();
                if (this.alreadyJoinedAliases.contains(path.getAlias())) {
                    orderElement = path.lastElement().map(element -> path.getAlias() + PERIOD + element.getFieldName()).orElse("");
                } else {
                    String prefix = prefixWithAlias ? Path.getTypeAlias((Class)sortClass) + PERIOD : "";
                    orderElement = prefix + path.getFieldPath();
                }
                orderElement = orderElement + SPACE + (((Sorting.SortOrder)entry.getValue()).equals((Object)Sorting.SortOrder.desc) ? "desc" : "asc");
                ordering.add(orderElement);
            });
            sortingRules = " order by " + StringUtils.join(ordering, (String)COMMA);
        }
        return sortingRules;
    }

    protected boolean containsOneToMany(FilterExpression filterExpression) {
        PredicateExtractionVisitor visitor = new PredicateExtractionVisitor(new ArrayList());
        Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)visitor);
        return predicates.stream().anyMatch(predicate -> FilterPredicate.toManyInPath((EntityDictionary)this.dictionary, (Path)predicate.getPath()));
    }

    public static interface Relationship {
        public Class<?> getParentType();

        public Class<?> getChildType();

        public String getRelationshipName();

        public Object getParent();

        public Collection<?> getChildren();
    }
}

