/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.FilterTranslator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import java.util.Collection;

public class RootCollectionFetchQueryBuilder
extends AbstractHQLQueryBuilder {
    private Class<?> entityClass;

    public RootCollectionFetchQueryBuilder(Class<?> entityClass, EntityDictionary dictionary, Session session) {
        super(dictionary, session);
        this.entityClass = dictionary.lookupEntityClass(entityClass);
    }

    @Override
    public Query build() {
        Query query;
        String entityName = this.entityClass.getCanonicalName();
        String entityAlias = FilterPredicate.getTypeAlias(this.entityClass);
        if (this.filterExpression.isPresent()) {
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            Collection predicates = (Collection)((FilterExpression)this.filterExpression.get()).accept((FilterExpressionVisitor)extractor);
            String filterClause = new FilterTranslator().apply((FilterExpression)this.filterExpression.get(), true);
            String joinClause = this.getJoinClauseFromFilters((FilterExpression)this.filterExpression.get()) + this.extractToOneMergeJoins(this.entityClass, entityAlias) + this.explicitSortJoins(this.sorting, this.entityClass);
            boolean requiresDistinct = this.pagination.isPresent() && this.containsOneToMany((FilterExpression)this.filterExpression.get());
            Boolean sortOverRelationship = this.sorting.map(sort -> sort.getValidSortingRules(this.entityClass, this.dictionary).keySet().stream().anyMatch(path -> path.getPathElements().size() > 1)).orElse(false);
            if (requiresDistinct && sortOverRelationship.booleanValue()) {
                throw new InvalidValueException((Object)"Combination of pagination, sorting over relationship and filtering over toMany relationships unsupported");
            }
            query = this.session.createQuery("SELECT " + (requiresDistinct ? "DISTINCT " : "") + entityAlias + " FROM " + entityName + " AS " + entityAlias + " " + joinClause + " " + filterClause + " " + this.getSortClause(this.sorting, this.entityClass, true));
            this.supplyFilterQueryParameters(query, predicates);
        } else {
            query = this.session.createQuery("SELECT " + entityAlias + " FROM " + entityName + " AS " + entityAlias + " " + this.extractToOneMergeJoins(this.entityClass, entityAlias) + this.explicitSortJoins(this.sorting, this.entityClass) + " " + this.getSortClause(this.sorting, this.entityClass, true));
        }
        this.addPaginationToQuery(query);
        return query;
    }
}

