/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.FilterTranslator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;

public class RootCollectionPageTotalsQueryBuilder
extends AbstractHQLQueryBuilder {
    private Class<?> entityClass;

    public RootCollectionPageTotalsQueryBuilder(Class<?> entityClass, EntityDictionary dictionary, Session session) {
        super(dictionary, session);
        this.entityClass = dictionary.lookupEntityClass(entityClass);
    }

    @Override
    public AbstractHQLQueryBuilder withPossiblePagination(Optional<Pagination> ignored) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractHQLQueryBuilder withPossibleSorting(Optional<Sorting> ignored) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query build() {
        String joinClause;
        String filterClause;
        HashSet<FilterPredicate> predicates;
        String entityName = this.entityClass.getCanonicalName();
        String entityAlias = FilterPredicate.getTypeAlias(this.entityClass);
        if (this.filterExpression.isPresent()) {
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            predicates = (Collection)((FilterExpression)this.filterExpression.get()).accept((FilterExpressionVisitor)extractor);
            filterClause = new FilterTranslator().apply((FilterExpression)this.filterExpression.get(), true);
            joinClause = this.getJoinClauseFromFilters((FilterExpression)this.filterExpression.get(), true);
        } else {
            predicates = new HashSet();
            filterClause = "";
            joinClause = "";
        }
        Query query = this.session.createQuery("SELECT COUNT(DISTINCT " + entityAlias + ") " + " FROM " + entityName + " AS " + entityAlias + " " + joinClause + " " + filterClause);
        this.supplyFilterQueryParameters(query, predicates);
        return query;
    }
}

