/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.FilterTranslator;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.sort.Sorting;
import java.util.Collection;
import java.util.function.Function;

public class SubCollectionFetchQueryBuilder
extends AbstractHQLQueryBuilder {
    private final AbstractHQLQueryBuilder.Relationship relationship;

    public SubCollectionFetchQueryBuilder(AbstractHQLQueryBuilder.Relationship relationship, EntityDictionary dictionary, Session session) {
        super(dictionary, session);
        this.relationship = relationship;
    }

    @Override
    protected String extractToOneMergeJoins(Class<?> entityClass, String alias) {
        Function<String, Boolean> shouldSkip = relationshipName -> {
            String inverseRelationName = this.dictionary.getRelationInverse(entityClass, relationshipName);
            if (inverseRelationName.isEmpty()) {
                return false;
            }
            Class relationshipClass = this.dictionary.getParameterizedType(entityClass, relationshipName);
            return relationshipClass.equals(this.relationship.getParentType()) && inverseRelationName.equals(this.relationship.getRelationshipName());
        };
        return this.extractToOneMergeJoins(entityClass, alias, shouldSkip);
    }

    @Override
    public Query build() {
        if (!(this.filterExpression.isPresent() || this.pagination.isPresent() || this.sorting.isPresent() && !((Sorting)this.sorting.get()).isDefaultInstance())) {
            return null;
        }
        String childAlias = FilterPredicate.getTypeAlias(this.relationship.getChildType());
        String parentAlias = FilterPredicate.getTypeAlias(this.relationship.getParentType()) + "__fetch";
        String parentName = this.relationship.getParentType().getCanonicalName();
        String relationshipName = this.relationship.getRelationshipName();
        Query query = this.filterExpression.map(fe -> {
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            Collection predicates = (Collection)fe.accept((FilterExpressionVisitor)extractor);
            String filterClause = new FilterTranslator().apply((FilterExpression)fe, true);
            String joinClause = this.getJoinClauseFromFilters((FilterExpression)this.filterExpression.get()) + this.extractToOneMergeJoins(this.relationship.getChildType(), childAlias) + this.explicitSortJoins(this.sorting, this.relationship.getChildType());
            Query q = this.session.createQuery("SELECT " + childAlias + " FROM " + parentName + " " + parentAlias + " JOIN " + parentAlias + "." + relationshipName + " " + childAlias + joinClause + " " + filterClause + " AND " + parentAlias + "=:" + parentAlias + " " + this.getSortClause(this.sorting, this.relationship.getChildType(), true));
            this.supplyFilterQueryParameters(q, predicates);
            return q;
        }).orElse(this.session.createQuery("SELECT " + childAlias + " FROM " + parentName + " " + parentAlias + " JOIN " + parentAlias + "." + relationshipName + " " + childAlias + this.extractToOneMergeJoins(this.relationship.getChildType(), childAlias) + this.explicitSortJoins(this.sorting, this.relationship.getChildType()) + " WHERE " + parentAlias + "=:" + parentAlias + this.getSortClause(this.sorting, this.relationship.getChildType(), true)));
        query.setParameter(parentAlias, this.relationship.getParent());
        this.addPaginationToQuery(query);
        return query;
    }
}

