/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.hibernate.hql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.FilterTranslator;
import com.yahoo.elide.core.filter.InPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.ExpressionScopingVisitor;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.hibernate.Query;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class SubCollectionPageTotalsQueryBuilder
extends AbstractHQLQueryBuilder {
    private final AbstractHQLQueryBuilder.Relationship relationship;

    public SubCollectionPageTotalsQueryBuilder(AbstractHQLQueryBuilder.Relationship relationship, EntityDictionary dictionary, Session session) {
        super(dictionary, session);
        this.relationship = relationship;
    }

    @Override
    public AbstractHQLQueryBuilder withPossiblePagination(Optional<Pagination> ignored) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractHQLQueryBuilder withPossibleSorting(Optional<Sorting> ignored) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query build() {
        Class parentType = this.dictionary.lookupEntityClass(this.relationship.getParentType());
        Class idType = this.dictionary.getIdType(parentType);
        Object idVal = CoerceUtil.coerce((Object)this.dictionary.getId(this.relationship.getParent()), (Class)idType);
        String idField = this.dictionary.getIdFieldName(parentType);
        InPredicate idExpression = new InPredicate(new Path.PathElement(parentType, idType, idField), new Object[]{idVal});
        Collection<FilterPredicate> predicates = new ArrayList<InPredicate>();
        String joinClause = "";
        String filterClause = "";
        String relationshipName = this.relationship.getRelationshipName();
        String parentAlias = FilterPredicate.getTypeAlias((Class)parentType);
        String relationshipAlias = parentAlias + "_" + relationshipName;
        if (this.filterExpression.isPresent()) {
            ExpressionScopingVisitor visitor = new ExpressionScopingVisitor(new Path.PathElement(parentType, this.relationship.getChildType(), this.relationship.getRelationshipName()));
            FilterExpression scoped = this.filterExpression.map(fe -> (FilterExpression)fe.accept((FilterExpressionVisitor)visitor)).orElseThrow(() -> new IllegalStateException("Filter expression cloned to null"));
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor(new ArrayList());
            predicates = (Collection)scoped.accept((FilterExpressionVisitor)extractor);
            predicates.add((FilterPredicate)idExpression);
            AndFilterExpression joinedExpression = new AndFilterExpression(scoped, (FilterExpression)idExpression);
            joinClause = this.getJoinClauseFromFilters((FilterExpression)joinedExpression, true);
            filterClause = new FilterTranslator().apply((FilterExpression)joinedExpression, true);
        } else {
            joinClause = " JOIN " + parentAlias + "." + relationshipName + " " + relationshipAlias + " ";
            filterClause = new FilterTranslator().apply((FilterExpression)idExpression, true);
            predicates.add((FilterPredicate)idExpression);
        }
        Query query = this.session.createQuery("SELECT COUNT(DISTINCT " + relationshipAlias + ") " + " FROM " + parentType.getCanonicalName() + " AS " + parentAlias + " " + joinClause + " " + filterClause);
        this.supplyFilterQueryParameters(query, predicates);
        return query;
    }
}

