/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.filter;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.filter.FilterOperation;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.jpql.filter.CaseAwareJPQLGenerator;
import com.yahoo.elide.datastores.jpql.filter.HasMemberJPQLGenerator;
import com.yahoo.elide.datastores.jpql.filter.JPQLPredicateGenerator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;

public class FilterTranslator
implements FilterOperation<String> {
    private static final String COMMA = ", ";
    private static final Map<Operator, JPQLPredicateGenerator> GLOBAL_OPERATOR_GENERATORS;
    private static final Map<Triple<Operator, Type<?>, String>, JPQLPredicateGenerator> GLOBAL_PREDICATE_OVERRIDES;
    private final Map<Operator, JPQLPredicateGenerator> operatorGenerators;
    private final Map<Triple<Operator, Type<?>, String>, JPQLPredicateGenerator> predicateOverrides;
    private final EntityDictionary dictionary;

    public static void registerJPQLGenerator(Operator op, JPQLPredicateGenerator generator) {
        GLOBAL_OPERATOR_GENERATORS.put(op, generator);
    }

    public static void registerJPQLGenerator(Operator op, Type<?> entityClass, String fieldName, JPQLPredicateGenerator generator) {
        GLOBAL_PREDICATE_OVERRIDES.put(Triple.of((Object)op, entityClass, (Object)fieldName), generator);
    }

    public static JPQLPredicateGenerator lookupJPQLGenerator(Operator op, Type<?> entityClass, String fieldName) {
        return GLOBAL_PREDICATE_OVERRIDES.get(Triple.of((Object)op, entityClass, (Object)fieldName));
    }

    public static JPQLPredicateGenerator lookupJPQLGenerator(Operator op) {
        return GLOBAL_OPERATOR_GENERATORS.get(op);
    }

    public FilterTranslator(EntityDictionary dictionary) {
        this.dictionary = dictionary;
        if (!GLOBAL_OPERATOR_GENERATORS.containsKey(Operator.HASMEMBER)) {
            GLOBAL_OPERATOR_GENERATORS.put(Operator.HASMEMBER, new HasMemberJPQLGenerator(dictionary));
        }
        if (!GLOBAL_OPERATOR_GENERATORS.containsKey(Operator.HASNOMEMBER)) {
            GLOBAL_OPERATOR_GENERATORS.put(Operator.HASNOMEMBER, new HasMemberJPQLGenerator(dictionary, true));
        }
        this.operatorGenerators = new HashMap<Operator, JPQLPredicateGenerator>(GLOBAL_OPERATOR_GENERATORS);
        this.predicateOverrides = new HashMap(GLOBAL_PREDICATE_OVERRIDES);
    }

    public FilterTranslator(EntityDictionary dictionary, Map<Operator, JPQLPredicateGenerator> operationOverrides) {
        this(dictionary);
        this.operatorGenerators.putAll(operationOverrides);
    }

    public String apply(FilterPredicate filterPredicate) {
        return this.apply(filterPredicate, this::expandPathNoAlias);
    }

    protected String apply(FilterPredicate filterPredicate, Function<Path, String> aliasGenerator) {
        Function<Path, String> removeThisFromAlias = path -> {
            String fieldPath = (String)aliasGenerator.apply((Path)path);
            return fieldPath.replaceAll("\\.this", "");
        };
        Path.PathElement last = (Path.PathElement)filterPredicate.getPath().lastElement().get();
        Operator op = filterPredicate.getOperator();
        JPQLPredicateGenerator generator = this.predicateOverrides.get(Triple.of((Object)op, (Object)last.getType(), (Object)last.getFieldName()));
        if (generator == null) {
            generator = this.operatorGenerators.get(op);
        }
        if (generator == null) {
            throw new BadRequestException("Operator not implemented: " + filterPredicate.getOperator());
        }
        return generator.generate(filterPredicate, removeThisFromAlias);
    }

    private static String greatestClause(List<FilterPredicate.FilterParameter> params) {
        return String.format("greatest(%s)", params.stream().map(FilterPredicate.FilterParameter::getPlaceholder).collect(Collectors.joining(COMMA)));
    }

    private static String leastClause(List<FilterPredicate.FilterParameter> params) {
        return String.format("least(%s)", params.stream().map(FilterPredicate.FilterParameter::getPlaceholder).collect(Collectors.joining(COMMA)));
    }

    public String apply(FilterExpression filterExpression, boolean prefixWithAlias) {
        Function<Path, String> aliasGenerator = this::expandPathNoAlias;
        if (prefixWithAlias) {
            aliasGenerator = this::expandPathWithAlias;
        }
        return this.apply(filterExpression, aliasGenerator);
    }

    public String expandPathNoAlias(Path path) {
        return path.getPathElements().stream().map(Path.PathElement::getFieldName).collect(Collectors.joining("."));
    }

    public String expandPathWithAlias(Path path) {
        return TypeHelper.getFieldAlias((String)TypeHelper.getPathAlias((Path)path, (EntityDictionary)this.dictionary), (String)path.lastElement().map(Path.PathElement::getFieldName).orElse(null));
    }

    public String apply(FilterExpression filterExpression, Function<Path, String> aliasGenerator) {
        JPQLQueryVisitor visitor = new JPQLQueryVisitor(aliasGenerator);
        return (String)filterExpression.accept((FilterExpressionVisitor)visitor);
    }

    static {
        GLOBAL_PREDICATE_OVERRIDES = new HashMap();
        GLOBAL_OPERATOR_GENERATORS = new EnumMap<Operator, JPQLPredicateGenerator>(Operator.class);
        GLOBAL_OPERATOR_GENERATORS.put(Operator.IN, new CaseAwareJPQLGenerator("%s IN (%s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.IN_INSENSITIVE, new CaseAwareJPQLGenerator("%s IN (%s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT, new CaseAwareJPQLGenerator("%s NOT IN (%s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT_INSENSITIVE, new CaseAwareJPQLGenerator("%s NOT IN (%s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.MANY));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.PREFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT_PREFIX, new CaseAwareJPQLGenerator("%s NOT LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.PREFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT_PREFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s NOT LIKE CONCAT(%s, '%%')", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.POSTFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT_POSTFIX, new CaseAwareJPQLGenerator("%s NOT LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.POSTFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT_POSTFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s NOT LIKE CONCAT('%%', %s)", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.INFIX, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', CONCAT(%s, '%%'))", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT_INFIX, new CaseAwareJPQLGenerator("%s NOT LIKE CONCAT('%%', CONCAT(%s, '%%'))", CaseAwareJPQLGenerator.Case.NONE, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.INFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s LIKE CONCAT('%%', CONCAT(%s, '%%'))", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOT_INFIX_CASE_INSENSITIVE, new CaseAwareJPQLGenerator("%s NOT LIKE CONCAT('%%', CONCAT(%s, '%%'))", CaseAwareJPQLGenerator.Case.LOWER, CaseAwareJPQLGenerator.ArgumentCount.ONE));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.LT, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s < %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.leastClause(predicate.getParameters()));
        });
        GLOBAL_OPERATOR_GENERATORS.put(Operator.LE, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s <= %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.leastClause(predicate.getParameters()));
        });
        GLOBAL_OPERATOR_GENERATORS.put(Operator.GT, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s > %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.greatestClause(predicate.getParameters()));
        });
        GLOBAL_OPERATOR_GENERATORS.put(Operator.GE, (predicate, aliasGenerator) -> {
            Preconditions.checkState((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
            return String.format("%s >= %s", aliasGenerator.apply(predicate.getPath()), predicate.getParameters().size() == 1 ? ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder() : FilterTranslator.greatestClause(predicate.getParameters()));
        });
        GLOBAL_OPERATOR_GENERATORS.put(Operator.ISNULL, (predicate, aliasGenerator) -> String.format("%s IS NULL", aliasGenerator.apply(predicate.getPath())));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOTNULL, (predicate, aliasGenerator) -> String.format("%s IS NOT NULL", aliasGenerator.apply(predicate.getPath())));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.TRUE, (predicate, aliasGenerator) -> "(1 = 1)");
        GLOBAL_OPERATOR_GENERATORS.put(Operator.FALSE, (predicate, aliasGenerator) -> "(1 = 0)");
        GLOBAL_OPERATOR_GENERATORS.put(Operator.ISEMPTY, (predicate, aliasGenerator) -> String.format("%s IS EMPTY", aliasGenerator.apply(predicate.getPath())));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOTEMPTY, (predicate, aliasGenerator) -> String.format("%s IS NOT EMPTY", aliasGenerator.apply(predicate.getPath())));
        GLOBAL_OPERATOR_GENERATORS.put(Operator.BETWEEN, (predicate, aliasGenerator) -> {
            List parameters = predicate.getParameters();
            Preconditions.checkState((!parameters.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0);
            return String.format("%s BETWEEN %s AND %s", aliasGenerator.apply(predicate.getPath()), ((FilterPredicate.FilterParameter)parameters.get(0)).getPlaceholder(), ((FilterPredicate.FilterParameter)parameters.get(1)).getPlaceholder());
        });
        GLOBAL_OPERATOR_GENERATORS.put(Operator.NOTBETWEEN, (predicate, aliasGenerator) -> {
            List parameters = predicate.getParameters();
            Preconditions.checkState((!parameters.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0);
            return String.format("%s NOT BETWEEN %s AND %s", aliasGenerator.apply(predicate.getPath()), ((FilterPredicate.FilterParameter)parameters.get(0)).getPlaceholder(), ((FilterPredicate.FilterParameter)parameters.get(1)).getPlaceholder());
        });
    }

    public class JPQLQueryVisitor
    implements FilterExpressionVisitor<String> {
        private final Function<Path, String> aliasGenerator;

        public JPQLQueryVisitor(Function<Path, String> aliasGenerator) {
            this.aliasGenerator = aliasGenerator;
        }

        public String visitPredicate(FilterPredicate filterPredicate) {
            return FilterTranslator.this.apply(filterPredicate, this.aliasGenerator);
        }

        public String visitAndExpression(AndFilterExpression expression) {
            FilterExpression left = expression.getLeft();
            FilterExpression right = expression.getRight();
            return "(" + (String)left.accept((FilterExpressionVisitor)this) + " AND " + (String)right.accept((FilterExpressionVisitor)this) + ")";
        }

        public String visitOrExpression(OrFilterExpression expression) {
            FilterExpression left = expression.getLeft();
            FilterExpression right = expression.getRight();
            return "(" + (String)left.accept((FilterExpressionVisitor)this) + " OR " + (String)right.accept((FilterExpressionVisitor)this) + ")";
        }

        public String visitNotExpression(NotFilterExpression expression) {
            String negated = (String)expression.getNegated().accept((FilterExpressionVisitor)this);
            return "NOT (" + negated + ")";
        }
    }
}

