/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.filter;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.jpql.filter.JPQLPredicateGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class HasMemberJPQLGenerator
implements JPQLPredicateGenerator {
    private final EntityDictionary dictionary;
    private final boolean negated;
    private static String INNER = "_INNER_";

    public HasMemberJPQLGenerator(EntityDictionary dictionary) {
        this(dictionary, false);
    }

    public HasMemberJPQLGenerator(EntityDictionary dictionary, boolean negated) {
        this.dictionary = dictionary;
        this.negated = negated;
    }

    @Override
    public String generate(FilterPredicate predicate, Function<Path, String> aliasGenerator) {
        String notMember;
        Preconditions.checkArgument((predicate.getParameters().size() == 1 ? 1 : 0) != 0);
        String string = notMember = this.negated ? "NOT " : "";
        if (!FilterPredicate.toManyInPath((EntityDictionary)this.dictionary, (Path)predicate.getPath())) {
            return String.format("%s %sMEMBER OF %s", ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder(), notMember, aliasGenerator.apply(predicate.getPath()));
        }
        Path path = predicate.getPath();
        Preconditions.checkArgument((boolean)path.lastElement().isPresent());
        Preconditions.checkArgument((!(((Path.PathElement)path.lastElement().get()).getType() instanceof Collection) ? 1 : 0) != 0);
        Object value = ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getValue();
        if (value == null || "null".equals(value)) {
            return String.format("%sEXISTS (SELECT 1 FROM %s WHERE %s = %s AND (%s IS NULL OR %s = %s))", notMember, this.getFromClause(path), this.getInnerQueryIdField(path), this.getOuterQueryIdField(path, aliasGenerator), this.getInnerFilterFieldReference(path), this.getInnerFilterFieldReference(path), ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder());
        }
        return String.format("%sEXISTS (SELECT 1 FROM %s WHERE %s = %s AND %s = %s)", notMember, this.getFromClause(path), this.getInnerQueryIdField(path), this.getOuterQueryIdField(path, aliasGenerator), this.getInnerFilterFieldReference(path), ((FilterPredicate.FilterParameter)predicate.getParameters().get(0)).getPlaceholder());
    }

    private String getOuterQueryIdField(Path path, Function<Path, String> aliasGenerator) {
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Type modelType = firstElement.getType();
        String idField = this.dictionary.getIdFieldName(modelType);
        Type idFieldType = this.dictionary.getIdType(modelType);
        Path idPath = new Path(Arrays.asList(new Path.PathElement(modelType, idFieldType, idField)));
        return aliasGenerator.apply(idPath);
    }

    private String getInnerQueryIdField(Path path) {
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Path firstElementPath = new Path(Arrays.asList(firstElement));
        Type modelType = firstElement.getType();
        String idField = this.dictionary.getIdFieldName(modelType);
        return INNER + TypeHelper.getPathAlias((Path)firstElementPath, (EntityDictionary)this.dictionary) + "." + idField;
    }

    private String getInnerFilterFieldReference(Path path) {
        Path.PathElement lastElement = (Path.PathElement)path.lastElement().get();
        String fieldName = lastElement.getFieldName();
        return INNER + TypeHelper.getPathAlias((Path)path, (EntityDictionary)this.dictionary) + "." + fieldName;
    }

    private String getFromClause(Path path) {
        Path.PathElement element;
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Path.PathElement lastElement = (Path.PathElement)path.lastElement().get();
        String entityName = firstElement.getType().getCanonicalName();
        Object currentAlias = INNER + TypeHelper.getTypeAlias((Type)firstElement.getType());
        StringBuilder fromClause = new StringBuilder();
        fromClause.append(entityName).append(" ").append((String)currentAlias);
        Iterator iterator = path.getPathElements().iterator();
        while (iterator.hasNext() && (element = (Path.PathElement)iterator.next()) != lastElement) {
            String nextAlias = TypeHelper.appendAlias((String)currentAlias, (String)element.getFieldName());
            fromClause.append(" LEFT JOIN ").append((String)currentAlias).append(".").append(element.getFieldName()).append(" ").append(nextAlias);
            currentAlias = nextAlias;
        }
        return fromClause.toString();
    }
}

