/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.filter;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.jpql.filter.JPQLPredicateGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SubsetOfJPQLGenerator
implements JPQLPredicateGenerator {
    private final EntityDictionary dictionary;
    private final boolean negated;
    private static String INNER = "_INNER_";

    public SubsetOfJPQLGenerator(EntityDictionary dictionary) {
        this(dictionary, false);
    }

    public SubsetOfJPQLGenerator(EntityDictionary dictionary, boolean negated) {
        this.dictionary = dictionary;
        this.negated = negated;
    }

    @Override
    public String generate(FilterPredicate predicate, Function<Path, String> aliasGenerator) {
        String notSubset;
        Preconditions.checkArgument((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
        String string = notSubset = this.negated ? "NOT " : "";
        if (!FilterPredicate.toManyInPath((EntityDictionary)this.dictionary, (Path)predicate.getPath())) {
            ArrayList<String> parts = new ArrayList<String>();
            for (FilterPredicate.FilterParameter parameter : predicate.getParameters()) {
                parts.add(String.format("(CASE %s MEMBER OF %s WHEN true THEN 1 ELSE 0 END)", parameter.getPlaceholder(), aliasGenerator.apply(predicate.getPath())));
            }
            String sum = parts.stream().collect(Collectors.joining(" + "));
            return String.format("%ssize(%s) = %s", notSubset, aliasGenerator.apply(predicate.getPath()), sum);
        }
        Path path = predicate.getPath();
        Preconditions.checkArgument((boolean)path.lastElement().isPresent());
        Preconditions.checkArgument((!(((Path.PathElement)path.lastElement().get()).getType() instanceof Collection) ? 1 : 0) != 0);
        String inClause = predicate.getParameters().stream().map(p -> p.getPlaceholder()).collect(Collectors.joining(","));
        return String.format("%s(SELECT COUNT(DISTINCT %s) FROM %s WHERE %s = %s) = (SELECT COUNT(DISTINCT %s) FROM %s WHERE %s = %s AND %s IN (%s))", notSubset, this.getInnerFilterFieldReference(path), this.getFromClause(path), this.getInnerQueryIdField(path), this.getOuterQueryIdField(path, aliasGenerator), this.getInnerFilterFieldReference(path), this.getFromClause(path), this.getInnerQueryIdField(path), this.getOuterQueryIdField(path, aliasGenerator), this.getInnerFilterFieldReference(path), inClause);
    }

    private String getOuterQueryIdField(Path path, Function<Path, String> aliasGenerator) {
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Type modelType = firstElement.getType();
        String idField = this.dictionary.getIdFieldName(modelType);
        Type idFieldType = this.dictionary.getIdType(modelType);
        Path idPath = new Path(Arrays.asList(new Path.PathElement(modelType, idFieldType, idField)));
        return aliasGenerator.apply(idPath);
    }

    private String getInnerQueryIdField(Path path) {
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Path firstElementPath = new Path(Arrays.asList(firstElement));
        Type modelType = firstElement.getType();
        String idField = this.dictionary.getIdFieldName(modelType);
        return INNER + TypeHelper.getPathAlias((Path)firstElementPath, (EntityDictionary)this.dictionary) + "." + idField;
    }

    private String getInnerFilterFieldReference(Path path) {
        Path.PathElement lastElement = (Path.PathElement)path.lastElement().get();
        String fieldName = lastElement.getFieldName();
        return INNER + TypeHelper.getPathAlias((Path)path, (EntityDictionary)this.dictionary) + "." + fieldName;
    }

    private String getFromClause(Path path) {
        Path.PathElement element;
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Path.PathElement lastElement = (Path.PathElement)path.lastElement().get();
        String entityName = firstElement.getType().getCanonicalName();
        Object currentAlias = INNER + TypeHelper.getTypeAlias((Type)firstElement.getType());
        StringBuilder fromClause = new StringBuilder();
        fromClause.append(entityName).append(" ").append((String)currentAlias);
        Iterator iterator = path.getPathElements().iterator();
        while (iterator.hasNext() && (element = (Path.PathElement)iterator.next()) != lastElement) {
            String nextAlias = TypeHelper.appendAlias((String)currentAlias, (String)element.getFieldName());
            fromClause.append(" LEFT JOIN ").append((String)currentAlias).append(".").append(element.getFieldName()).append(" ").append(nextAlias);
            currentAlias = nextAlias;
        }
        return fromClause.toString();
    }
}

