/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.filter;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.jpql.filter.JPQLPredicateGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SupersetOfJPQLGenerator
implements JPQLPredicateGenerator {
    private final EntityDictionary dictionary;
    private final boolean negated;
    private static String INNER = "_INNER_";

    public SupersetOfJPQLGenerator(EntityDictionary dictionary) {
        this(dictionary, false);
    }

    public SupersetOfJPQLGenerator(EntityDictionary dictionary, boolean negated) {
        this.dictionary = dictionary;
        this.negated = negated;
    }

    @Override
    public String generate(FilterPredicate predicate, Function<Path, String> aliasGenerator) {
        String notSuperset;
        Preconditions.checkArgument((!predicate.getParameters().isEmpty() ? 1 : 0) != 0);
        String string = notSuperset = this.negated ? "NOT " : "";
        if (!FilterPredicate.toManyInPath((EntityDictionary)this.dictionary, (Path)predicate.getPath())) {
            ArrayList<String> parts = new ArrayList<String>();
            for (FilterPredicate.FilterParameter parameter : predicate.getParameters()) {
                parts.add(String.format("%s %sMEMBER OF %s", parameter.getPlaceholder(), notSuperset, aliasGenerator.apply(predicate.getPath())));
            }
            String operator = this.negated ? " OR " : " AND ";
            return parts.stream().collect(Collectors.joining(operator));
        }
        Path path = predicate.getPath();
        Preconditions.checkArgument((boolean)path.lastElement().isPresent());
        Preconditions.checkArgument((!(((Path.PathElement)path.lastElement().get()).getType() instanceof Collection) ? 1 : 0) != 0);
        int size = predicate.getValues().stream().collect(Collectors.toSet()).size();
        String inClause = predicate.getParameters().stream().map(p -> p.getPlaceholder()).collect(Collectors.joining(","));
        return String.format("%s%s = (SELECT COUNT(DISTINCT %s) FROM %s WHERE %s = %s AND %s IN (%s))", notSuperset, size, this.getInnerFilterFieldReference(path), this.getFromClause(path), this.getInnerQueryIdField(path), this.getOuterQueryIdField(path, aliasGenerator), this.getInnerFilterFieldReference(path), inClause);
    }

    private String getOuterQueryIdField(Path path, Function<Path, String> aliasGenerator) {
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Type modelType = firstElement.getType();
        String idField = this.dictionary.getIdFieldName(modelType);
        Type idFieldType = this.dictionary.getIdType(modelType);
        Path idPath = new Path(Arrays.asList(new Path.PathElement(modelType, idFieldType, idField)));
        return aliasGenerator.apply(idPath);
    }

    private String getInnerQueryIdField(Path path) {
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Path firstElementPath = new Path(Arrays.asList(firstElement));
        Type modelType = firstElement.getType();
        String idField = this.dictionary.getIdFieldName(modelType);
        return INNER + TypeHelper.getPathAlias((Path)firstElementPath, (EntityDictionary)this.dictionary) + "." + idField;
    }

    private String getInnerFilterFieldReference(Path path) {
        Path.PathElement lastElement = (Path.PathElement)path.lastElement().get();
        String fieldName = lastElement.getFieldName();
        return INNER + TypeHelper.getPathAlias((Path)path, (EntityDictionary)this.dictionary) + "." + fieldName;
    }

    private String getFromClause(Path path) {
        Path.PathElement element;
        Path.PathElement firstElement = (Path.PathElement)path.getPathElements().get(0);
        Path.PathElement lastElement = (Path.PathElement)path.lastElement().get();
        String entityName = firstElement.getType().getCanonicalName();
        Object currentAlias = INNER + TypeHelper.getTypeAlias((Type)firstElement.getType());
        StringBuilder fromClause = new StringBuilder();
        fromClause.append(entityName).append(" ").append((String)currentAlias);
        Iterator iterator = path.getPathElements().iterator();
        while (iterator.hasNext() && (element = (Path.PathElement)iterator.next()) != lastElement) {
            String nextAlias = TypeHelper.appendAlias((String)currentAlias, (String)element.getFieldName());
            fromClause.append(" LEFT JOIN ").append((String)currentAlias).append(".").append(element.getFieldName()).append(" ").append(nextAlias);
            currentAlias = nextAlias;
        }
        return fromClause.toString();
    }
}

