/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpql.query;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.TypeHelper;
import com.yahoo.elide.datastores.jpql.filter.FilterTranslator;
import com.yahoo.elide.datastores.jpql.porting.Query;
import com.yahoo.elide.datastores.jpql.porting.Session;
import com.yahoo.elide.datastores.jpql.porting.SingleResultQuery;
import com.yahoo.elide.datastores.jpql.query.AbstractHQLQueryBuilder;
import java.util.Collection;
import java.util.function.Supplier;

public class RootCollectionFetchQueryBuilder
extends AbstractHQLQueryBuilder {
    public RootCollectionFetchQueryBuilder(EntityProjection entityProjection, EntityDictionary dictionary, Session session) {
        super(entityProjection, dictionary, session);
    }

    @Override
    public Query build() {
        Query query;
        Type entityClass = this.entityProjection.getType();
        String entityName = entityClass.getCanonicalName();
        String entityAlias = TypeHelper.getTypeAlias((Type)entityClass);
        FilterExpression filterExpression = this.entityProjection.getFilterExpression();
        if (filterExpression != null) {
            boolean sortOverRelationship;
            String joinClause = this.getJoinClauseFromFilters(filterExpression) + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(entityClass, entityAlias);
            String filterClause = " WHERE " + new FilterTranslator(this.dictionary).apply(filterExpression, true);
            if (joinClause.isEmpty() && filterExpression instanceof InPredicate) {
                InPredicate inPredicate = (InPredicate)filterExpression;
                if (this.entityProjection.getSorting() == null && inPredicate.getField().equals(this.dictionary.getIdFieldName(entityClass)) && inPredicate.getValues().size() == 1) {
                    String queryText = "SELECT " + entityAlias + " FROM " + entityName + " AS " + entityAlias + filterClause;
                    Supplier<Object> result = () -> this.session.find(queryText, (Class)entityClass.getUnderlyingClass().get(), inPredicate.getValues().get(0));
                    return new SingleResultQuery(result);
                }
            }
            PredicateExtractionVisitor extractor = new PredicateExtractionVisitor();
            Collection predicates = (Collection)filterExpression.accept((FilterExpressionVisitor)extractor);
            boolean requiresDistinct = this.containsOneToMany(filterExpression);
            boolean bl = sortOverRelationship = this.entityProjection.getSorting() != null && this.entityProjection.getSorting().getSortingPaths().keySet().stream().anyMatch(path -> path.getPathElements().stream().anyMatch(element -> this.dictionary.isRelation(element.getType(), element.getFieldName())));
            if (requiresDistinct && sortOverRelationship) {
                throw new InvalidValueException((Object)"Combination of pagination, sorting over relationship and filtering over toMany relationships unsupported");
            }
            query = this.session.createQuery("SELECT " + (requiresDistinct ? "DISTINCT " : "") + entityAlias + " FROM " + entityName + " AS " + entityAlias + " " + joinClause + " " + filterClause + " " + this.getSortClause(this.entityProjection.getSorting()));
            this.supplyFilterQueryParameters(query, predicates);
        } else {
            query = this.session.createQuery("SELECT " + entityAlias + " FROM " + entityName + " AS " + entityAlias + " " + this.getJoinClauseFromSort(this.entityProjection.getSorting()) + this.extractToOneMergeJoins(entityClass, entityAlias) + " " + this.getSortClause(this.entityProjection.getSorting()));
        }
        this.addPaginationToQuery(query);
        return query;
    }
}

