/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.ArgumentType;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.datastores.jms.JMSDataStoreTransaction;
import com.yahoo.elide.graphql.subscriptions.annotations.Subscription;
import com.yahoo.elide.graphql.subscriptions.hooks.SubscriptionFieldSerde;
import com.yahoo.elide.graphql.subscriptions.hooks.TopicType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;

public class JMSDataStore
implements DataStore {
    protected Map<com.yahoo.elide.core.type.Type<?>, Boolean> models;
    protected ConnectionFactory connectionFactory;
    protected EntityDictionary dictionary;
    protected long timeoutInMs = -1L;
    protected Gson gson;

    public JMSDataStore(Set<com.yahoo.elide.core.type.Type<?>> models, ConnectionFactory connectionFactory, EntityDictionary dictionary, long timeoutInMs) {
        this.models = models.stream().collect(Collectors.toMap(model -> model, model -> {
            Subscription subscription = (Subscription)model.getAnnotation(Subscription.class);
            return subscription != null && subscription.operations() != null && subscription.operations().length > 0;
        }));
        this.connectionFactory = connectionFactory;
        this.dictionary = dictionary;
        this.timeoutInMs = timeoutInMs;
        GsonBuilder gsonBuilder = new GsonBuilder();
        CoerceUtil.getSerdes().forEach((cls, serde) -> gsonBuilder.registerTypeAdapter((Type)cls, (Object)new SubscriptionFieldSerde(serde)));
        this.gson = gsonBuilder.create();
    }

    public JMSDataStore(ClassScanner scanner, ConnectionFactory connectionFactory, EntityDictionary dictionary, long timeoutInMs) {
        this(scanner.getAnnotatedClasses(new Class[]{Subscription.class, Include.class}).stream().map(ClassType::of).collect(Collectors.toSet()), connectionFactory, dictionary, timeoutInMs);
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (com.yahoo.elide.core.type.Type<?> model : this.models.keySet()) {
            Boolean supportsTopics = this.models.get(model);
            dictionary.bindEntity(model);
            if (!supportsTopics.booleanValue()) continue;
            dictionary.addArgumentToEntity(model, ArgumentType.builder().name("topic").defaultValue((Object)TopicType.ADDED).type((com.yahoo.elide.core.type.Type)ClassType.of(TopicType.class)).build());
        }
    }

    public DataStoreTransaction beginTransaction() {
        JMSContext context = this.connectionFactory.createContext();
        return new JMSDataStoreTransaction(context, this.dictionary, this.gson, this.timeoutInMs);
    }

    public DataStoreTransaction beginReadTransaction() {
        JMSContext context = this.connectionFactory.createContext();
        return new JMSDataStoreTransaction(context, this.dictionary, this.gson, this.timeoutInMs);
    }
}

