/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms;

import com.yahoo.elide.core.datastore.DataStoreIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.jms.JMSConsumer;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;

public class MessageIterable<T>
implements DataStoreIterable<T> {
    private JMSConsumer consumer;
    private long timeout;
    private Function<Message, T> messageConverter;

    public MessageIterable(JMSConsumer consumer, long timeout, Function<Message, T> messageConverter) {
        this.consumer = consumer;
        this.timeout = timeout;
        this.messageConverter = messageConverter;
    }

    public Iterable<T> getWrappedIterable() {
        return this;
    }

    public Iterator<T> iterator() {
        return new Iterator(){
            T next;

            @Override
            public boolean hasNext() {
                try {
                    this.next = this.next();
                }
                catch (NoSuchElementException e) {
                    return false;
                }
                return true;
            }

            public T next() {
                if (this.next != null) {
                    Object result = this.next;
                    this.next = null;
                    return result;
                }
                try {
                    Message message = MessageIterable.this.timeout == 0L ? MessageIterable.this.consumer.receiveNoWait() : (MessageIterable.this.timeout > 0L ? MessageIterable.this.consumer.receive(MessageIterable.this.timeout) : MessageIterable.this.consumer.receive());
                    if (message != null) {
                        return MessageIterable.this.messageConverter.apply(message);
                    }
                    throw new NoSuchElementException();
                }
                catch (JMSRuntimeException e) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    public boolean needsInMemoryFilter() {
        return true;
    }

    public boolean needsInMemorySort() {
        return true;
    }

    public boolean needsInMemoryPagination() {
        return true;
    }
}

