/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms.websocket;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettingsBuilder;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.audit.Slf4jLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.ErrorMapper;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.datastores.jms.JMSDataStore;
import com.yahoo.elide.graphql.ExecutionResultDeserializer;
import com.yahoo.elide.graphql.ExecutionResultSerializer;
import com.yahoo.elide.graphql.GraphQLErrorDeserializer;
import com.yahoo.elide.graphql.GraphQLErrorSerializer;
import com.yahoo.elide.graphql.subscriptions.websocket.SubscriptionWebSocket;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import java.util.Calendar;
import javax.jms.ConnectionFactory;
import javax.websocket.server.ServerEndpointConfig;

public class SubscriptionWebSocketConfigurator
extends ServerEndpointConfig.Configurator {
    protected ConnectionFactory connectionFactory;
    protected AuditLogger auditLogger;
    protected ErrorMapper errorMapper;
    protected String baseUrl;
    protected boolean verboseErrors;
    protected int connectionTimeoutMs;
    protected int maxSubscriptions;
    private long maxIdleTimeoutMs;
    private int maxMessageSize;
    protected SubscriptionWebSocket.UserFactory userFactory;
    protected boolean sendPingOnSubscribe;

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        if (endpointClass.equals(SubscriptionWebSocket.class)) {
            EntityDictionary dictionary = EntityDictionary.builder().build();
            DataStore store = this.buildDataStore(dictionary);
            Elide elide = this.buildElide(store, dictionary);
            return (T)this.buildWebSocket(elide);
        }
        return (T)super.getEndpointInstance(endpointClass);
    }

    protected Elide buildElide(DataStore store, EntityDictionary dictionary) {
        RSQLFilterDialect rsqlFilterStrategy = RSQLFilterDialect.builder().dictionary(dictionary).build();
        ElideSettingsBuilder builder = new ElideSettingsBuilder(store).withAuditLogger(this.auditLogger).withErrorMapper(this.errorMapper).withBaseUrl(this.baseUrl).withJoinFilterDialect((JoinFilterDialect)rsqlFilterStrategy).withSubqueryFilterDialect((SubqueryFilterDialect)rsqlFilterStrategy).withEntityDictionary(dictionary).withISO8601Dates("yyyy-MM-dd'T'HH:mm'Z'", Calendar.getInstance().getTimeZone());
        if (this.verboseErrors) {
            builder = builder.withVerboseErrors();
        }
        Elide elide = new Elide(builder.build());
        elide.doScans();
        return elide;
    }

    protected DataStore buildDataStore(EntityDictionary dictionary) {
        return new JMSDataStore(dictionary.getScanner(), this.connectionFactory, dictionary, -1L);
    }

    protected SubscriptionWebSocket buildWebSocket(Elide elide) {
        elide.getMapper().getObjectMapper().registerModule((Module)new SimpleModule("ExecutionResult").addDeserializer(GraphQLError.class, (JsonDeserializer)new GraphQLErrorDeserializer()).addDeserializer(ExecutionResult.class, (JsonDeserializer)new ExecutionResultDeserializer()).addSerializer(GraphQLError.class, (JsonSerializer)new GraphQLErrorSerializer()).addSerializer(ExecutionResult.class, (JsonSerializer)new ExecutionResultSerializer(new GraphQLErrorSerializer())));
        return SubscriptionWebSocket.builder().elide(elide).connectTimeoutMs(this.connectionTimeoutMs).maxSubscriptions(this.maxSubscriptions).maxMessageSize(this.maxMessageSize).maxIdleTimeoutMs(this.maxIdleTimeoutMs).userFactory(this.userFactory).sendPingOnSubscribe(this.sendPingOnSubscribe).verboseErrors(this.verboseErrors).build();
    }

    private static AuditLogger $default$auditLogger() {
        return new Slf4jLogger();
    }

    private static ErrorMapper $default$errorMapper() {
        return error -> null;
    }

    private static String $default$baseUrl() {
        return "/";
    }

    private static boolean $default$verboseErrors() {
        return false;
    }

    private static int $default$connectionTimeoutMs() {
        return 5000;
    }

    private static int $default$maxSubscriptions() {
        return 30;
    }

    private static long $default$maxIdleTimeoutMs() {
        return 300000L;
    }

    private static int $default$maxMessageSize() {
        return 10000;
    }

    private static SubscriptionWebSocket.UserFactory $default$userFactory() {
        return SubscriptionWebSocket.DEFAULT_USER_FACTORY;
    }

    private static boolean $default$sendPingOnSubscribe() {
        return false;
    }

    public static SubscriptionWebSocketConfiguratorBuilder builder() {
        return new SubscriptionWebSocketConfiguratorBuilder();
    }

    protected SubscriptionWebSocketConfigurator(ConnectionFactory connectionFactory, AuditLogger auditLogger, ErrorMapper errorMapper, String baseUrl, boolean verboseErrors, int connectionTimeoutMs, int maxSubscriptions, long maxIdleTimeoutMs, int maxMessageSize, SubscriptionWebSocket.UserFactory userFactory, boolean sendPingOnSubscribe) {
        this.connectionFactory = connectionFactory;
        this.auditLogger = auditLogger;
        this.errorMapper = errorMapper;
        this.baseUrl = baseUrl;
        this.verboseErrors = verboseErrors;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.maxSubscriptions = maxSubscriptions;
        this.maxIdleTimeoutMs = maxIdleTimeoutMs;
        this.maxMessageSize = maxMessageSize;
        this.userFactory = userFactory;
        this.sendPingOnSubscribe = sendPingOnSubscribe;
    }

    public static class SubscriptionWebSocketConfiguratorBuilder {
        private ConnectionFactory connectionFactory;
        private boolean auditLogger$set;
        private AuditLogger auditLogger$value;
        private boolean errorMapper$set;
        private ErrorMapper errorMapper$value;
        private boolean baseUrl$set;
        private String baseUrl$value;
        private boolean verboseErrors$set;
        private boolean verboseErrors$value;
        private boolean connectionTimeoutMs$set;
        private int connectionTimeoutMs$value;
        private boolean maxSubscriptions$set;
        private int maxSubscriptions$value;
        private boolean maxIdleTimeoutMs$set;
        private long maxIdleTimeoutMs$value;
        private boolean maxMessageSize$set;
        private int maxMessageSize$value;
        private boolean userFactory$set;
        private SubscriptionWebSocket.UserFactory userFactory$value;
        private boolean sendPingOnSubscribe$set;
        private boolean sendPingOnSubscribe$value;

        SubscriptionWebSocketConfiguratorBuilder() {
        }

        public SubscriptionWebSocketConfiguratorBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder auditLogger(AuditLogger auditLogger) {
            this.auditLogger$value = auditLogger;
            this.auditLogger$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder errorMapper(ErrorMapper errorMapper) {
            this.errorMapper$value = errorMapper;
            this.errorMapper$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder baseUrl(String baseUrl) {
            this.baseUrl$value = baseUrl;
            this.baseUrl$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder verboseErrors(boolean verboseErrors) {
            this.verboseErrors$value = verboseErrors;
            this.verboseErrors$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder connectionTimeoutMs(int connectionTimeoutMs) {
            this.connectionTimeoutMs$value = connectionTimeoutMs;
            this.connectionTimeoutMs$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder maxSubscriptions(int maxSubscriptions) {
            this.maxSubscriptions$value = maxSubscriptions;
            this.maxSubscriptions$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder maxIdleTimeoutMs(long maxIdleTimeoutMs) {
            this.maxIdleTimeoutMs$value = maxIdleTimeoutMs;
            this.maxIdleTimeoutMs$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize$value = maxMessageSize;
            this.maxMessageSize$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder userFactory(SubscriptionWebSocket.UserFactory userFactory) {
            this.userFactory$value = userFactory;
            this.userFactory$set = true;
            return this;
        }

        public SubscriptionWebSocketConfiguratorBuilder sendPingOnSubscribe(boolean sendPingOnSubscribe) {
            this.sendPingOnSubscribe$value = sendPingOnSubscribe;
            this.sendPingOnSubscribe$set = true;
            return this;
        }

        public SubscriptionWebSocketConfigurator build() {
            AuditLogger auditLogger$value = this.auditLogger$value;
            if (!this.auditLogger$set) {
                auditLogger$value = SubscriptionWebSocketConfigurator.$default$auditLogger();
            }
            ErrorMapper errorMapper$value = this.errorMapper$value;
            if (!this.errorMapper$set) {
                errorMapper$value = SubscriptionWebSocketConfigurator.$default$errorMapper();
            }
            String baseUrl$value = this.baseUrl$value;
            if (!this.baseUrl$set) {
                baseUrl$value = SubscriptionWebSocketConfigurator.$default$baseUrl();
            }
            boolean verboseErrors$value = this.verboseErrors$value;
            if (!this.verboseErrors$set) {
                verboseErrors$value = SubscriptionWebSocketConfigurator.$default$verboseErrors();
            }
            int connectionTimeoutMs$value = this.connectionTimeoutMs$value;
            if (!this.connectionTimeoutMs$set) {
                connectionTimeoutMs$value = SubscriptionWebSocketConfigurator.$default$connectionTimeoutMs();
            }
            int maxSubscriptions$value = this.maxSubscriptions$value;
            if (!this.maxSubscriptions$set) {
                maxSubscriptions$value = SubscriptionWebSocketConfigurator.$default$maxSubscriptions();
            }
            long maxIdleTimeoutMs$value = this.maxIdleTimeoutMs$value;
            if (!this.maxIdleTimeoutMs$set) {
                maxIdleTimeoutMs$value = SubscriptionWebSocketConfigurator.$default$maxIdleTimeoutMs();
            }
            int maxMessageSize$value = this.maxMessageSize$value;
            if (!this.maxMessageSize$set) {
                maxMessageSize$value = SubscriptionWebSocketConfigurator.$default$maxMessageSize();
            }
            SubscriptionWebSocket.UserFactory userFactory$value = this.userFactory$value;
            if (!this.userFactory$set) {
                userFactory$value = SubscriptionWebSocketConfigurator.$default$userFactory();
            }
            boolean sendPingOnSubscribe$value = this.sendPingOnSubscribe$value;
            if (!this.sendPingOnSubscribe$set) {
                sendPingOnSubscribe$value = SubscriptionWebSocketConfigurator.$default$sendPingOnSubscribe();
            }
            return new SubscriptionWebSocketConfigurator(this.connectionFactory, auditLogger$value, errorMapper$value, baseUrl$value, verboseErrors$value, connectionTimeoutMs$value, maxSubscriptions$value, maxIdleTimeoutMs$value, maxMessageSize$value, userFactory$value, sendPingOnSubscribe$value);
        }

        public String toString() {
            return "SubscriptionWebSocketConfigurator.SubscriptionWebSocketConfiguratorBuilder(connectionFactory=" + this.connectionFactory + ", auditLogger$value=" + this.auditLogger$value + ", errorMapper$value=" + this.errorMapper$value + ", baseUrl$value=" + this.baseUrl$value + ", verboseErrors$value=" + this.verboseErrors$value + ", connectionTimeoutMs$value=" + this.connectionTimeoutMs$value + ", maxSubscriptions$value=" + this.maxSubscriptions$value + ", maxIdleTimeoutMs$value=" + this.maxIdleTimeoutMs$value + ", maxMessageSize$value=" + this.maxMessageSize$value + ", userFactory$value=" + this.userFactory$value + ", sendPingOnSubscribe$value=" + this.sendPingOnSubscribe$value + ")";
        }
    }
}

