/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.ArgumentType;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.datastores.jms.JMSDataStoreTransaction;
import com.yahoo.elide.graphql.subscriptions.annotations.Subscription;
import com.yahoo.elide.graphql.subscriptions.hooks.TopicType;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JMSDataStore
implements DataStore {
    protected Map<Type<?>, Boolean> models;
    protected ConnectionFactory connectionFactory;
    protected EntityDictionary dictionary;
    protected long timeoutInMs = -1L;
    protected ObjectMapper objectMapper;

    public JMSDataStore(Set<Type<?>> models, ConnectionFactory connectionFactory, EntityDictionary dictionary, ObjectMapper objectMapper, Duration timeout) {
        this.models = models.stream().collect(Collectors.toMap(model -> model, model -> {
            Subscription subscription = (Subscription)model.getAnnotation(Subscription.class);
            return subscription != null && subscription.operations() != null && subscription.operations().length > 0;
        }));
        this.connectionFactory = connectionFactory;
        this.dictionary = dictionary;
        this.objectMapper = objectMapper;
        this.timeoutInMs = timeout != null ? timeout.toMillis() : -1L;
    }

    public JMSDataStore(ClassScanner scanner, ConnectionFactory connectionFactory, EntityDictionary dictionary, ObjectMapper objectMapper, Duration timeout) {
        this(scanner.getAnnotatedClasses(new Class[]{Subscription.class, Include.class}).stream().map(ClassType::of).collect(Collectors.toSet()), connectionFactory, dictionary, objectMapper, timeout);
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        for (Type<?> model : this.models.keySet()) {
            Boolean supportsTopics = this.models.get(model);
            dictionary.bindEntity(model);
            if (!Boolean.TRUE.equals(supportsTopics)) continue;
            dictionary.addArgumentToEntity(model, ArgumentType.builder().name("topic").defaultValue((Object)TopicType.ADDED).type((Type)ClassType.of(TopicType.class)).build());
        }
    }

    public DataStoreTransaction beginTransaction() {
        JMSContext context = this.connectionFactory.createContext();
        return new JMSDataStoreTransaction(context, this.dictionary, this.objectMapper, this.timeoutInMs);
    }

    public DataStoreTransaction beginReadTransaction() {
        return this.beginTransaction();
    }
}

