/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jms;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.type.Type;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.util.function.Function;

public class MessageDeserializer<T>
implements Function<Message, T> {
    private Type<?> type;
    private ObjectMapper objectMapper;

    public MessageDeserializer(Type<?> type, ObjectMapper objectMapper) {
        this.type = type;
        this.objectMapper = objectMapper;
    }

    @Override
    public T apply(Message message) {
        try {
            return (T)this.objectMapper.readValue(((TextMessage)message).getText(), (Class)this.type.getUnderlyingClass().get());
        }
        catch (JsonProcessingException | JMSException e) {
            throw new InternalServerErrorException(e);
        }
    }
}

