/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.datastore.JPQLDataStore;
import com.yahoo.elide.datastores.jpa.transaction.JpaTransaction;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;

public class JpaDataStore
implements JPQLDataStore {
    protected final EntityManagerSupplier entityManagerSupplier;
    protected final JpaTransactionSupplier readTransactionSupplier;
    protected final JpaTransactionSupplier writeTransactionSupplier;
    protected final Set<Class<?>> modelsToBind;

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier readTransactionSupplier, JpaTransactionSupplier writeTransactionSupplier, Class<?> ... models) {
        this.entityManagerSupplier = entityManagerSupplier;
        this.readTransactionSupplier = readTransactionSupplier;
        this.writeTransactionSupplier = writeTransactionSupplier;
        this.modelsToBind = new HashSet();
        for (Class<?> model : models) {
            this.modelsToBind.add(model);
        }
    }

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier transactionSupplier, Class<?> ... models) {
        this(entityManagerSupplier, transactionSupplier, transactionSupplier, models);
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        if (!this.modelsToBind.isEmpty()) {
            this.modelsToBind.stream().forEach(model -> this.bindEntityClass((Class)model, dictionary));
            return;
        }
        for (EntityType type : this.entityManagerSupplier.get().getMetamodel().getEntities()) {
            try {
                Class mappedClass = type.getJavaType();
                dictionary.lookupEntityClass(mappedClass);
                this.bindEntityClass(mappedClass, dictionary);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public DataStoreTransaction beginReadTransaction() {
        EntityManager entityManager = this.entityManagerSupplier.get();
        JpaTransaction transaction = this.readTransactionSupplier.get(entityManager);
        transaction.begin();
        return transaction;
    }

    public DataStoreTransaction beginTransaction() {
        EntityManager entityManager = this.entityManagerSupplier.get();
        JpaTransaction transaction = this.writeTransactionSupplier.get(entityManager);
        transaction.begin();
        return transaction;
    }

    @FunctionalInterface
    public static interface JpaTransactionSupplier {
        public JpaTransaction get(EntityManager var1);
    }

    @FunctionalInterface
    public static interface EntityManagerSupplier {
        public EntityManager get();
    }
}

