/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa.transaction;

import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.hibernate.Session;
import com.yahoo.elide.core.hibernate.hql.AbstractHQLQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RelationshipImpl;
import com.yahoo.elide.core.hibernate.hql.RootCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.RootCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionFetchQueryBuilder;
import com.yahoo.elide.core.hibernate.hql.SubCollectionPageTotalsQueryBuilder;
import com.yahoo.elide.core.pagination.Pagination;
import com.yahoo.elide.core.sort.Sorting;
import com.yahoo.elide.datastores.jpa.porting.EntityManagerWrapper;
import com.yahoo.elide.datastores.jpa.porting.QueryWrapper;
import com.yahoo.elide.datastores.jpa.transaction.JpaTransaction;
import com.yahoo.elide.datastores.jpa.transaction.checker.PersistentCollectionChecker;
import com.yahoo.elide.security.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJpaTransaction
implements JpaTransaction {
    private static final Logger log = LoggerFactory.getLogger(AbstractJpaTransaction.class);
    private static final Predicate<Collection<?>> IS_PERSISTENT_COLLECTION = new PersistentCollectionChecker();
    protected final EntityManager em;
    private final EntityManagerWrapper emWrapper;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();

    protected AbstractJpaTransaction(EntityManager em) {
        this.em = em;
        this.emWrapper = new EntityManagerWrapper(em);
    }

    public void delete(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> this.em.remove(object));
    }

    public void save(Object object, RequestScope scope) {
        this.deferredTasks.add(() -> {
            if (!this.em.contains(object)) {
                this.em.merge(object);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(RequestScope requestScope) {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            FlushModeType flushMode = this.em.getFlushMode();
            if (flushMode == FlushModeType.AUTO && this.isOpen()) {
                this.em.flush();
            }
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            finally {
                log.error("Caught entity manager exception during flush", (Throwable)e);
            }
            if (e instanceof ConstraintViolationException) {
                throw e;
            }
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public abstract boolean isOpen();

    public void commit(RequestScope scope) {
        this.flush(scope);
    }

    @Override
    public void rollback() {
        this.deferredTasks.clear();
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            this.rollback();
        }
        if (this.deferredTasks.size() > 0) {
            throw new IOException("Transaction not closed");
        }
    }

    public void createObject(Object entity, RequestScope scope) {
        this.deferredTasks.add(() -> {
            if (!this.em.contains(entity)) {
                this.em.persist(entity);
            }
        });
    }

    public Object loadObject(Class<?> entityClass, Serializable id, Optional<FilterExpression> filterExpression, RequestScope scope) {
        try {
            EntityDictionary dictionary = scope.getDictionary();
            Class idType = dictionary.getIdType(entityClass);
            String idField = dictionary.getIdFieldName(entityClass);
            Path.PathElement idPath = new Path.PathElement(entityClass, idType, idField);
            FilterPredicate idExpression = id != null ? new FilterPredicate(idPath, Operator.IN, Collections.singletonList(id)) : new FilterPredicate(idPath, Operator.FALSE, Collections.emptyList());
            FilterExpression joinedExpression = filterExpression.map(fe -> new AndFilterExpression(fe, (FilterExpression)idExpression)).orElse((FilterExpression)idExpression);
            QueryWrapper query = (QueryWrapper)new RootCollectionFetchQueryBuilder(entityClass, dictionary, (Session)this.emWrapper).withPossibleFilterExpression(Optional.of(joinedExpression)).build();
            return query.getQuery().getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Iterable<Object> loadObjects(Class<?> entityClass, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        QueryWrapper query = (QueryWrapper)new RootCollectionFetchQueryBuilder(entityClass, scope.getDictionary(), (Session)this.emWrapper).withPossibleFilterExpression(filterExpression).withPossibleSorting(sorting).withPossiblePagination(pagination).build();
        List results = query.getQuery().getResultList();
        pagination.ifPresent(p -> {
            if (p.isGenerateTotals() && (!results.isEmpty() || p.getLimit() == 0)) {
                p.setPageTotals(this.getTotalRecords(entityClass, filterExpression, scope.getDictionary()).longValue());
            }
        });
        return results;
    }

    public Object getRelation(DataStoreTransaction relationTx, Object entity, String relationName, Optional<FilterExpression> filterExpression, Optional<Sorting> sorting, Optional<Pagination> pagination, RequestScope scope) {
        Collection filteredVal;
        EntityDictionary dictionary = scope.getDictionary();
        Object val = PersistentResource.getValue((Object)entity, (String)relationName, (RequestScope)scope);
        if (val instanceof Collection && IS_PERSISTENT_COLLECTION.test(filteredVal = (Collection)val)) {
            if (!(filterExpression.isPresent() || sorting.isPresent() || pagination.isPresent() && !pagination.get().isDefaultInstance())) {
                return val;
            }
            Class relationClass = dictionary.getParameterizedType(entity, relationName);
            RelationshipImpl relationship = new RelationshipImpl(dictionary.lookupEntityClass(entity.getClass()), relationClass, relationName, entity, filteredVal);
            pagination.ifPresent(p -> {
                if (p.isGenerateTotals()) {
                    p.setPageTotals(this.getTotalRecords((AbstractHQLQueryBuilder.Relationship)relationship, filterExpression, dictionary).longValue());
                }
            });
            QueryWrapper query = (QueryWrapper)new SubCollectionFetchQueryBuilder((AbstractHQLQueryBuilder.Relationship)relationship, dictionary, (Session)this.emWrapper).withPossibleFilterExpression(filterExpression).withPossibleSorting(sorting).withPossiblePagination(pagination).build();
            if (query != null) {
                return query.getQuery().getResultList();
            }
        }
        return val;
    }

    private <T> Long getTotalRecords(Class<T> entityClass, Optional<FilterExpression> filterExpression, EntityDictionary dictionary) {
        QueryWrapper query = (QueryWrapper)new RootCollectionPageTotalsQueryBuilder(entityClass, dictionary, (Session)this.emWrapper).withPossibleFilterExpression(filterExpression).build();
        return (Long)query.getQuery().getSingleResult();
    }

    private <T> Long getTotalRecords(AbstractHQLQueryBuilder.Relationship relationship, Optional<FilterExpression> filterExpression, EntityDictionary dictionary) {
        QueryWrapper query = (QueryWrapper)new SubCollectionPageTotalsQueryBuilder(relationship, dictionary, (Session)this.emWrapper).withPossibleFilterExpression(filterExpression).build();
        return (Long)query.getQuery().getSingleResult();
    }

    public User accessUser(Object opaqueUser) {
        return new User(opaqueUser);
    }
}

