/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa.transaction;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.datastores.jpa.transaction.AbstractJpaTransaction;
import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonJtaTransaction
extends AbstractJpaTransaction {
    private static final Logger log = LoggerFactory.getLogger(NonJtaTransaction.class);
    private final EntityTransaction transaction;

    public NonJtaTransaction(EntityManager entityManager) {
        super(entityManager);
        this.transaction = entityManager.getTransaction();
        entityManager.clear();
    }

    @Override
    public void begin() {
        if (!this.transaction.isActive()) {
            this.transaction.begin();
        }
    }

    @Override
    public void commit(RequestScope scope) {
        if (this.transaction.isActive()) {
            super.commit(scope);
            this.transaction.commit();
        }
    }

    @Override
    public void rollback() {
        if (this.transaction.isActive()) {
            try {
                super.rollback();
            }
            finally {
                this.transaction.rollback();
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.em.close();
    }

    @Override
    public boolean isOpen() {
        return this.transaction.isActive();
    }
}

