/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa;

import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.jpa.transaction.JpaTransaction;
import com.yahoo.elide.datastores.jpql.JPQLDataStore;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import com.yahoo.elide.datastores.jpql.query.DefaultQueryLogger;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaDataStore
implements JPQLDataStore {
    private static final Logger log = LoggerFactory.getLogger(JpaDataStore.class);
    public static final QueryLogger DEFAULT_LOGGER = new DefaultQueryLogger();
    protected final EntityManagerSupplier entityManagerSupplier;
    protected final JpaTransactionSupplier readTransactionSupplier;
    protected final JpaTransactionSupplier writeTransactionSupplier;
    protected final MetamodelSupplier metamodelSupplier;
    protected final Set<Type<?>> modelsToBind;
    protected final QueryLogger queryLogger;

    private JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier readTransactionSupplier, JpaTransactionSupplier writeTransactionSupplier, QueryLogger queryLogger, MetamodelSupplier metamodelSupplier, Type<?>[] models) {
        this.entityManagerSupplier = entityManagerSupplier;
        this.readTransactionSupplier = readTransactionSupplier;
        this.writeTransactionSupplier = writeTransactionSupplier;
        this.metamodelSupplier = metamodelSupplier;
        this.queryLogger = queryLogger;
        this.modelsToBind = new HashSet();
        if (models != null) {
            Collections.addAll(this.modelsToBind, models);
        }
        if (this.metamodelSupplier == null && this.modelsToBind.isEmpty()) {
            throw new IllegalArgumentException("Either the metamodel supplier or the explicit models to bind needs to be provided.");
        }
    }

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier readTransactionSupplier, JpaTransactionSupplier writeTransactionSupplier, QueryLogger queryLogger, MetamodelSupplier metamodelSupplier) {
        this(entityManagerSupplier, readTransactionSupplier, writeTransactionSupplier, queryLogger, metamodelSupplier, null);
    }

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier readTransactionSupplier, JpaTransactionSupplier writeTransactionSupplier, QueryLogger queryLogger, Type<?> ... models) {
        this(entityManagerSupplier, readTransactionSupplier, writeTransactionSupplier, queryLogger, (MetamodelSupplier)null, models);
    }

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier transactionSupplier, MetamodelSupplier metamodelSupplier) {
        this(entityManagerSupplier, transactionSupplier, transactionSupplier, DEFAULT_LOGGER, metamodelSupplier);
    }

    public JpaDataStore(EntityManagerSupplier entityManagerSupplier, JpaTransactionSupplier transactionSupplier, Type<?> ... models) {
        this(entityManagerSupplier, transactionSupplier, transactionSupplier, DEFAULT_LOGGER, models);
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        if (!this.modelsToBind.isEmpty()) {
            this.modelsToBind.forEach(model -> this.bindEntityClass((Type)model, dictionary));
            return;
        }
        for (EntityType type : this.metamodelSupplier.get().getEntities()) {
            try {
                ClassType mappedClass = ClassType.of((Class)type.getJavaType());
                dictionary.lookupEntityClass((Type)mappedClass);
                this.bindEntityClass((Type)mappedClass, dictionary);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public DataStoreTransaction beginReadTransaction() {
        EntityManager entityManager = this.entityManagerSupplier.get();
        JpaTransaction transaction = this.readTransactionSupplier.get(entityManager);
        transaction.begin();
        return transaction;
    }

    public DataStoreTransaction beginTransaction() {
        EntityManager entityManager = this.entityManagerSupplier.get();
        JpaTransaction transaction = this.writeTransactionSupplier.get(entityManager);
        transaction.begin();
        return transaction;
    }

    @FunctionalInterface
    public static interface EntityManagerSupplier {
        public EntityManager get();
    }

    @FunctionalInterface
    public static interface JpaTransactionSupplier {
        public JpaTransaction get(EntityManager var1);
    }

    @FunctionalInterface
    public static interface MetamodelSupplier {
        public Metamodel get();
    }
}

