/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa.porting;

import com.yahoo.elide.datastores.jpa.JpaDataStore;
import com.yahoo.elide.datastores.jpa.porting.QueryWrapper;
import com.yahoo.elide.datastores.jpql.porting.Query;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import com.yahoo.elide.datastores.jpql.porting.Session;
import jakarta.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerWrapper
implements Session {
    private static final Logger log = LoggerFactory.getLogger(EntityManagerWrapper.class);
    private EntityManager entityManager;
    private QueryLogger logger;

    public EntityManagerWrapper(EntityManager entityManager) {
        this(entityManager, JpaDataStore.DEFAULT_LOGGER);
    }

    public EntityManagerWrapper(EntityManager entityManager, QueryLogger logger) {
        this.entityManager = entityManager;
        this.logger = logger;
    }

    public Query createQuery(String queryText) {
        QueryWrapper query = new QueryWrapper(this.entityManager.createQuery(queryText));
        this.logger.log(String.format("Query Hash: %d\tHQL Query: %s", query.hashCode(), queryText));
        return query;
    }

    public <T> T find(String queryText, Class<T> entityClass, Object primaryKey) {
        this.logger.log(String.format("Query Hash: %d\tHQL Query: %s", queryText.hashCode(), queryText));
        return (T)this.entityManager.find(entityClass, primaryKey);
    }
}

