/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa.transaction;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.datastores.jpa.porting.EntityManagerWrapper;
import com.yahoo.elide.datastores.jpa.transaction.JpaTransaction;
import com.yahoo.elide.datastores.jpa.transaction.checker.PersistentCollectionChecker;
import com.yahoo.elide.datastores.jpql.JPQLTransaction;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import com.yahoo.elide.datastores.jpql.porting.Session;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.NoResultException;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJpaTransaction
extends JPQLTransaction
implements JpaTransaction {
    private static final Logger log = LoggerFactory.getLogger(AbstractJpaTransaction.class);
    public static final String ENTITY_MANAGER_PROPERTY = AbstractJpaTransaction.class.getPackage().getName() + ".entityManager";
    private static final Predicate<Collection<?>> IS_PERSISTENT_COLLECTION = new PersistentCollectionChecker();
    protected final EntityManager em;
    private final LinkedHashSet<Runnable> deferredTasks = new LinkedHashSet();
    private final Consumer<EntityManager> jpaTransactionCancel;

    protected AbstractJpaTransaction(EntityManager em, Consumer<EntityManager> jpaTransactionCancel, QueryLogger logger, boolean delegateToInMemoryStore, boolean isScrollEnabled) {
        super((Session)new EntityManagerWrapper(em, logger), delegateToInMemoryStore, isScrollEnabled);
        this.em = em;
        this.jpaTransactionCancel = jpaTransactionCancel;
    }

    protected AbstractJpaTransaction(EntityManager em, Consumer<EntityManager> jpaTransactionCancel, QueryLogger logger, boolean delegateToInMemoryStore) {
        this(em, jpaTransactionCancel, logger, delegateToInMemoryStore, true);
    }

    public <T> void delete(T object, RequestScope scope) {
        this.deferredTasks.add(() -> this.em.remove(object));
    }

    public <T> void save(T object, RequestScope scope) {
        this.deferredTasks.add(() -> {
            if (!this.em.contains(object)) {
                this.em.merge(object);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(RequestScope requestScope) {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.deferredTasks.forEach(Runnable::run);
            this.deferredTasks.clear();
            FlushModeType flushMode = this.em.getFlushMode();
            if (flushMode == FlushModeType.AUTO && this.isOpen()) {
                this.em.flush();
            }
        }
        catch (Exception e) {
            try {
                this.rollback();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            finally {
                log.error("Caught entity manager exception during flush", (Throwable)e);
            }
            if (e instanceof ConstraintViolationException) {
                throw e;
            }
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public abstract boolean isOpen();

    public void commit(RequestScope scope) {
        this.flush(scope);
    }

    @Override
    public void rollback() {
        this.deferredTasks.clear();
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            this.rollback();
        }
        if (CollectionUtils.isNotEmpty(this.deferredTasks)) {
            throw new IOException("Transaction not closed");
        }
    }

    public <T> void createObject(T entity, RequestScope scope) {
        this.deferredTasks.add(() -> {
            if (!this.em.contains(entity)) {
                this.em.persist(entity);
            }
        });
    }

    public <T> T loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        try {
            return (T)super.loadObject(projection, id, scope);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void cancel(RequestScope scope) {
        this.jpaTransactionCancel.accept(this.em);
    }

    public <T> T getProperty(String propertyName) {
        if (ENTITY_MANAGER_PROPERTY.equals(propertyName)) {
            return (T)this.em;
        }
        return (T)super.getProperty(propertyName);
    }

    protected Predicate<Collection<?>> isPersistentCollection() {
        return IS_PERSISTENT_COLLECTION;
    }
}

