/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa.transaction;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.datastores.jpa.transaction.AbstractJpaTransaction;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import jakarta.persistence.EntityManager;
import jakarta.transaction.UserTransaction;
import java.util.function.Consumer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransaction
extends AbstractJpaTransaction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JtaTransaction.class);
    private final UserTransaction transaction;

    public JtaTransaction(EntityManager entityManager, UserTransaction transaction, Consumer<EntityManager> txCancel, QueryLogger logger, boolean delegateToInMemoryStore) {
        super(entityManager, txCancel, logger, delegateToInMemoryStore);
        this.transaction = transaction;
    }

    private static UserTransaction lookupUserTransaction() {
        try {
            return (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            log.error("Fail lookup UserTransaction from InitialContext", (Throwable)e);
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public void begin() {
        try {
            this.transaction.begin();
        }
        catch (Exception e) {
            log.error("Fail UserTransaction#begin()", (Throwable)e);
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public void commit(RequestScope scope) {
        super.commit(scope);
        try {
            this.transaction.commit();
        }
        catch (Exception e) {
            log.error("Fail UserTransaction#commit()", (Throwable)e);
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public void rollback() {
        super.rollback();
        try {
            this.transaction.rollback();
        }
        catch (Exception e) {
            log.error("Fail UserTransaction#rollback()", (Throwable)e);
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return this.transaction.getStatus() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

