/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.jpa.transaction;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.datastores.jpa.JpaDataStore;
import com.yahoo.elide.datastores.jpa.transaction.AbstractJpaTransaction;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.io.IOException;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonJtaTransaction
extends AbstractJpaTransaction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonJtaTransaction.class);
    private final EntityTransaction transaction;

    public NonJtaTransaction(EntityManager entityManager, Consumer<EntityManager> jpaTransactionCancel) {
        this(entityManager, jpaTransactionCancel, JpaDataStore.DEFAULT_LOGGER, false, true);
    }

    public NonJtaTransaction(EntityManager entityManager, Consumer<EntityManager> jpaTransactionCancel, QueryLogger logger, boolean delegateToInMemoryStore, boolean isScrollEnabled) {
        super(entityManager, jpaTransactionCancel, logger, delegateToInMemoryStore, isScrollEnabled);
        this.transaction = entityManager.getTransaction();
        entityManager.clear();
    }

    @Override
    public void begin() {
        if (!this.transaction.isActive()) {
            this.transaction.begin();
        }
    }

    @Override
    public void commit(RequestScope scope) {
        if (this.transaction.isActive()) {
            super.commit(scope);
            this.transaction.commit();
        }
    }

    @Override
    public void rollback() {
        if (this.transaction.isActive()) {
            try {
                super.rollback();
            }
            finally {
                this.transaction.rollback();
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.em.close();
    }

    @Override
    public boolean isOpen() {
        return this.transaction.isActive();
    }
}

