/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class Entity {
    private Optional<Entity> parentResource;
    private Map<String, Object> data;
    private Class<?> entityClass;
    private RequestScope requestScope;
    private Set<Attribute> attributes;
    private Set<Relationship> relationships;

    public Entity(Optional<Entity> parentResource, Map<String, Object> data, Class<?> entityClass, RequestScope requestScope) {
        this.parentResource = parentResource;
        this.data = data;
        this.entityClass = entityClass;
        this.requestScope = requestScope;
        this.setAttributes();
        this.setRelationships();
    }

    private void setAttributes() {
        if (this.data != null) {
            this.attributes = new LinkedHashSet<Attribute>();
            EntityDictionary dictionary = this.requestScope.getDictionary();
            String idFieldName = dictionary.getIdFieldName(this.entityClass);
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                if (dictionary.isAttribute(this.entityClass, entry.getKey())) {
                    this.attributes.add(new Attribute(entry.getKey(), entry.getValue()));
                }
                if (!Objects.equals(entry.getKey(), idFieldName)) continue;
                this.attributes.add(new Attribute(entry.getKey(), entry.getValue()));
            }
        }
    }

    private void setRelationships() {
        if (this.data != null) {
            this.relationships = new LinkedHashSet<Relationship>();
            EntityDictionary dictionary = this.requestScope.getDictionary();
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                if (!dictionary.isRelation(this.entityClass, entry.getKey())) continue;
                LinkedHashSet<Entity> entitySet = new LinkedHashSet<Entity>();
                Class loadClass = dictionary.getParameterizedType(this.entityClass, entry.getKey());
                Boolean isToOne = dictionary.getRelationshipType(this.entityClass, entry.getKey()).isToOne();
                if (isToOne.booleanValue()) {
                    entitySet.add(new Entity(Optional.of(this), (Map)entry.getValue(), loadClass, this.requestScope));
                } else {
                    for (Map row : (List)entry.getValue()) {
                        entitySet.add(new Entity(Optional.of(this), row, loadClass, this.requestScope));
                    }
                }
                this.relationships.add(new Relationship(entry.getKey(), entitySet));
            }
        }
    }

    public Optional<Relationship> getRelationship(String name) {
        for (Relationship relationship : this.relationships) {
            if (!relationship.getName().equals(name)) continue;
            return Optional.of(relationship);
        }
        return Optional.empty();
    }

    public Optional<Attribute> getAttribute(String name) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            return Optional.of(attribute);
        }
        return Optional.empty();
    }

    public Optional<String> getId() {
        EntityDictionary dictionary = this.requestScope.getDictionary();
        String idFieldName = dictionary.getIdFieldName(this.entityClass);
        return this.attributes.stream().filter(entry -> idFieldName.equalsIgnoreCase(((Attribute)entry).name)).map(e -> (String)((Attribute)e).value).findFirst();
    }

    public void setId() {
        if (!this.getId().isPresent()) {
            EntityDictionary dictionary = this.requestScope.getDictionary();
            String idFieldName = dictionary.getIdFieldName(this.entityClass);
            String uuid = UUID.randomUUID().toString();
            this.attributes.add(new Attribute(idFieldName, uuid));
        }
    }

    public PersistentResource toPersistentResource() {
        return this.data == null ? null : PersistentResource.loadRecord(this.entityClass, (String)this.getId().orElse(null), (RequestScope)this.requestScope);
    }

    public Optional<Entity> getParentResource() {
        return this.parentResource;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    class Relationship {
        private String name;
        private Set<Entity> value;

        public Relationship(String name, Set<Entity> value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Set<Entity> getValue() {
            return this.value;
        }
    }

    public class Attribute {
        private String name;
        private Object value;

        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

