/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.graphql.GraphQLRequestScope;
import com.yahoo.elide.graphql.containers.GraphQLContainer;
import com.yahoo.elide.graphql.containers.PersistentResourceContainer;
import com.yahoo.elide.graphql.containers.RootContainer;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Environment {
    public final GraphQLRequestScope requestScope;
    public final Optional<List<String>> ids;
    public final Optional<String> sort;
    public final Optional<List<Map<String, Object>>> data;
    public final Optional<String> filters;
    public final Optional<String> offset;
    public final Optional<String> first;
    public final Object rawSource;
    public final GraphQLContainer container;
    public final PersistentResource parentResource;
    public final GraphQLType parentType;
    public final GraphQLType outputType;
    public final Field field;

    public Environment(DataFetchingEnvironment environment) {
        Map args = environment.getArguments();
        this.requestScope = (GraphQLRequestScope)((Object)environment.getContext());
        this.filters = Optional.ofNullable((String)args.get("filter"));
        this.offset = Optional.ofNullable((String)args.get("after"));
        this.first = Optional.ofNullable((String)args.get("first"));
        this.sort = Optional.ofNullable((String)args.get("sort"));
        this.parentType = environment.getParentType();
        this.outputType = environment.getFieldType();
        this.rawSource = environment.getSource();
        GraphQLContainer graphQLContainer = this.container = this.isRoot() ? new RootContainer() : (GraphQLContainer)this.rawSource;
        if (this.isRoot()) {
            this.requestScope.saveOrCreateObjects();
            this.requestScope.getTransaction().flush((RequestScope)this.requestScope);
        }
        this.parentResource = this.rawSource instanceof PersistentResourceContainer ? ((PersistentResourceContainer)this.rawSource).getPersistentResource() : null;
        this.field = (Field)environment.getFields().get(0);
        this.ids = Optional.ofNullable((List)args.get("ids"));
        List<Map> data = args.get("data") instanceof Map ? Arrays.asList((Map)args.get("data")) : (List<Map>)args.get("data");
        this.data = Optional.ofNullable(data);
    }

    public boolean isRoot() {
        return !(this.rawSource instanceof GraphQLContainer);
    }
}

