/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.graphql.GraphQLScalars;
import com.yahoo.elide.graphql.NonEntityDictionary;
import com.yahoo.elide.graphql.SerdeCoercing;
import com.yahoo.elide.utils.coerce.CoerceUtil;
import com.yahoo.elide.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.utils.coerce.converters.Serde;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLConversionUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphQLConversionUtils.class);
    protected static final String MAP = "Map";
    protected static final String KEY = "key";
    protected static final String VALUE = "value";
    protected static final String ERROR_MESSAGE = "Value should either be integer, String or float";
    private final Map<Class<?>, GraphQLScalarType> scalarMap = new HashMap();
    protected NonEntityDictionary nonEntityDictionary;
    protected EntityDictionary entityDictionary;
    private final Map<Class, GraphQLObjectType> outputConversions = new HashMap<Class, GraphQLObjectType>();
    private final Map<Class, GraphQLInputObjectType> inputConversions = new HashMap<Class, GraphQLInputObjectType>();
    private final Map<Class, GraphQLEnumType> enumConversions = new HashMap<Class, GraphQLEnumType>();
    private final Map<String, GraphQLList> mapConversions = new HashMap<String, GraphQLList>();

    public GraphQLConversionUtils(EntityDictionary entityDictionary, NonEntityDictionary nonEntityDictionary) {
        this.entityDictionary = entityDictionary;
        this.nonEntityDictionary = nonEntityDictionary;
        this.registerCustomScalars();
    }

    private void registerCustomScalars() {
        for (Class serdeType : CoerceUtil.getSerdes().keySet()) {
            Serde serde = CoerceUtil.lookup((Class)serdeType);
            ElideTypeConverter elideTypeConverter = serde.getClass().getAnnotation(ElideTypeConverter.class);
            if (elideTypeConverter == null) continue;
            SerdeCoercing serdeCoercing = new SerdeCoercing(ERROR_MESSAGE, serde);
            this.scalarMap.put(elideTypeConverter.type(), new GraphQLScalarType(elideTypeConverter.name(), elideTypeConverter.description(), serdeCoercing));
        }
    }

    public GraphQLScalarType classToScalarType(Class<?> clazz) {
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Scalars.GraphQLInt;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return Scalars.GraphQLBoolean;
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Scalars.GraphQLLong;
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Scalars.GraphQLFloat;
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return Scalars.GraphQLFloat;
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return Scalars.GraphQLShort;
        }
        if (clazz.equals(String.class)) {
            return Scalars.GraphQLString;
        }
        if (clazz.equals(BigDecimal.class)) {
            return Scalars.GraphQLBigDecimal;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return GraphQLScalars.GRAPHQL_DATE_TYPE;
        }
        if (this.scalarMap.containsKey(clazz)) {
            return this.scalarMap.get(clazz);
        }
        return null;
    }

    public GraphQLEnumType classToEnumType(Class<?> enumClazz) {
        if (this.enumConversions.containsKey(enumClazz)) {
            return this.enumConversions.get(enumClazz);
        }
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum().name(this.toValidNameName(enumClazz.getName()));
        for (Enum value : values) {
            builder.value(this.toValidNameName(value.name()), (Object)value);
        }
        GraphQLEnumType enumResult = builder.build();
        this.enumConversions.put(enumClazz, enumResult);
        return enumResult;
    }

    public GraphQLList classToQueryMap(Class<?> keyClazz, Class<?> valueClazz, DataFetcher fetcher) {
        String mapName = this.toValidNameName(keyClazz.getName() + valueClazz.getCanonicalName() + MAP);
        if (this.mapConversions.containsKey(mapName)) {
            return this.mapConversions.get(mapName);
        }
        GraphQLOutputType keyType = this.fetchScalarOrObjectOutput(keyClazz, fetcher);
        GraphQLOutputType valueType = this.fetchScalarOrObjectOutput(valueClazz, fetcher);
        GraphQLList outputMap = new GraphQLList((GraphQLType)GraphQLObjectType.newObject().name(mapName).field(GraphQLFieldDefinition.newFieldDefinition().name(KEY).dataFetcher(fetcher).type(keyType)).field(GraphQLFieldDefinition.newFieldDefinition().name(VALUE).dataFetcher(fetcher).type(valueType)).build());
        this.mapConversions.put(mapName, outputMap);
        return this.mapConversions.get(mapName);
    }

    public GraphQLList classToInputMap(Class<?> keyClazz, Class<?> valueClazz) {
        String mapName = this.toValidNameName("_input__" + keyClazz.getName() + valueClazz.getCanonicalName() + MAP);
        if (this.mapConversions.containsKey(mapName)) {
            return this.mapConversions.get(mapName);
        }
        GraphQLInputType keyType = this.fetchScalarOrObjectInput(keyClazz);
        GraphQLInputType valueType = this.fetchScalarOrObjectInput(valueClazz);
        GraphQLList inputMap = new GraphQLList((GraphQLType)GraphQLInputObjectType.newInputObject().name(mapName).field(GraphQLInputObjectField.newInputObjectField().name(KEY).type(keyType)).field(GraphQLInputObjectField.newInputObjectField().name(VALUE).type(valueType)).build());
        this.mapConversions.put(mapName, inputMap);
        return inputMap;
    }

    public GraphQLOutputType attributeToQueryObject(Class<?> parentClass, Class<?> attributeClass, String attribute, DataFetcher fetcher) {
        return this.attributeToQueryObject(parentClass, attributeClass, attribute, fetcher, this.entityDictionary);
    }

    protected GraphQLOutputType attributeToQueryObject(Class<?> parentClass, Class<?> attributeClass, String attribute, DataFetcher fetcher, EntityDictionary dictionary) {
        if (this.outputConversions.containsKey(attributeClass)) {
            return (GraphQLOutputType)this.outputConversions.get(attributeClass);
        }
        if (this.enumConversions.containsKey(attributeClass)) {
            return (GraphQLOutputType)this.enumConversions.get(attributeClass);
        }
        if (Class.class.isAssignableFrom(attributeClass)) {
            return null;
        }
        if (Map.class.isAssignableFrom(attributeClass)) {
            Class keyType = dictionary.getParameterizedType(parentClass, attribute, 0);
            Class valueType = dictionary.getParameterizedType(parentClass, attribute, 1);
            return this.classToQueryMap(keyType, valueType, fetcher);
        }
        if (Collection.class.isAssignableFrom(attributeClass)) {
            Class listType = dictionary.getParameterizedType(parentClass, attribute, 0);
            return new GraphQLList((GraphQLType)this.fetchScalarOrObjectOutput(listType, fetcher));
        }
        return this.fetchScalarOrObjectOutput(attributeClass, fetcher);
    }

    public GraphQLInputType attributeToInputObject(Class<?> parentClass, Class<?> attributeClass, String attribute) {
        return this.attributeToInputObject(parentClass, attributeClass, attribute, this.entityDictionary);
    }

    protected String toValidNameName(String input) {
        return input.replace(".", "_").replace("$", "__1").replace("[", "___2");
    }

    protected GraphQLInputType attributeToInputObject(Class<?> parentClass, Class<?> attributeClass, String attribute, EntityDictionary dictionary) {
        if (this.inputConversions.containsKey(attributeClass)) {
            return (GraphQLInputType)this.inputConversions.get(attributeClass);
        }
        if (this.enumConversions.containsKey(attributeClass)) {
            return (GraphQLInputType)this.enumConversions.get(attributeClass);
        }
        if (Class.class.isAssignableFrom(attributeClass)) {
            return null;
        }
        if (Map.class.isAssignableFrom(attributeClass)) {
            Class keyType = dictionary.getParameterizedType(parentClass, attribute, 0);
            Class valueType = dictionary.getParameterizedType(parentClass, attribute, 1);
            return this.classToInputMap(keyType, valueType);
        }
        if (Collection.class.isAssignableFrom(attributeClass)) {
            Class listType = dictionary.getParameterizedType(parentClass, attribute, 0);
            return new GraphQLList((GraphQLType)this.fetchScalarOrObjectInput(listType));
        }
        return this.fetchScalarOrObjectInput(attributeClass);
    }

    public GraphQLObjectType classToQueryObject(Class<?> clazz, DataFetcher fetcher) {
        log.info("Building query object for type: {}", (Object)clazz.getName());
        if (!this.nonEntityDictionary.hasBinding(clazz)) {
            this.nonEntityDictionary.bindEntity(clazz);
        }
        if (this.outputConversions.containsKey(clazz)) {
            return this.outputConversions.get(clazz);
        }
        GraphQLObjectType.Builder objectBuilder = GraphQLObjectType.newObject();
        objectBuilder.name(this.toValidNameName(clazz.getName()));
        for (String attribute : this.nonEntityDictionary.getAttributes(clazz)) {
            Class attributeClass = this.nonEntityDictionary.getType(clazz, attribute);
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(attribute).dataFetcher(fetcher);
            GraphQLOutputType attributeType = this.attributeToQueryObject(clazz, attributeClass, attribute, fetcher, this.nonEntityDictionary);
            if (attributeType == null) continue;
            fieldBuilder.type(attributeType);
            objectBuilder.field(fieldBuilder);
        }
        GraphQLObjectType object = objectBuilder.build();
        this.outputConversions.put(clazz, object);
        return object;
    }

    public GraphQLInputObjectType classToInputObject(Class<?> clazz) {
        log.info("Building input object for type: {}", (Object)clazz.getName());
        if (!this.nonEntityDictionary.hasBinding(clazz)) {
            this.nonEntityDictionary.bindEntity(clazz);
        }
        if (this.inputConversions.containsKey(clazz)) {
            return this.inputConversions.get(clazz);
        }
        GraphQLInputObjectType.Builder objectBuilder = GraphQLInputObjectType.newInputObject();
        objectBuilder.name(this.toValidNameName("_input__" + clazz.getName()));
        for (String attribute : this.nonEntityDictionary.getAttributes(clazz)) {
            log.info("Building input object attribute: {}", (Object)attribute);
            Class attributeClass = this.nonEntityDictionary.getType(clazz, attribute);
            GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField().name(attribute);
            GraphQLInputType attributeType = this.attributeToInputObject(clazz, attributeClass, attribute, this.nonEntityDictionary);
            if (attributeType == null) continue;
            fieldBuilder.type(attributeType);
            objectBuilder.field(fieldBuilder);
        }
        GraphQLInputObjectType object = objectBuilder.build();
        this.inputConversions.put(clazz, object);
        return object;
    }

    private GraphQLOutputType fetchScalarOrObjectOutput(Class<?> conversionClass, DataFetcher fetcher) {
        if (conversionClass.isEnum()) {
            return this.classToEnumType(conversionClass);
        }
        GraphQLScalarType outputType = this.classToScalarType(conversionClass);
        if (outputType == null) {
            outputType = this.classToQueryObject(conversionClass, fetcher);
        }
        return outputType;
    }

    private GraphQLInputType fetchScalarOrObjectInput(Class<?> conversionClass) {
        if (conversionClass.isEnum()) {
            return this.classToEnumType(conversionClass);
        }
        GraphQLScalarType inputType = this.classToScalarType(conversionClass);
        if (inputType == null) {
            inputType = this.classToInputObject(conversionClass);
        }
        return inputType;
    }
}

