/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.resources.DefaultOpaqueUserFunction;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Produces(value={"application/json"})
@Path(value="/")
public class GraphQLEndpoint {
    private static final Logger log = LoggerFactory.getLogger(GraphQLEndpoint.class);
    private static final DefaultOpaqueUserFunction DEFAULT_GET_USER = securityContext -> securityContext;
    protected final Function<SecurityContext, Object> getUser;
    private final QueryRunner runner;

    @Inject
    public GraphQLEndpoint(@Named(value="elide") Elide elide, @Named(value="elideUserExtractionFunction") DefaultOpaqueUserFunction getUser) {
        log.debug("Started ~~");
        this.runner = new QueryRunner(elide);
        this.getUser = getUser == null ? DEFAULT_GET_USER : getUser;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response post(@Context UriInfo uriInfo, @Context SecurityContext securityContext, String graphQLDocument) {
        ElideResponse response = this.runner.run(uriInfo.getBaseUri().toString(), graphQLDocument, this.getUser.apply(securityContext));
        return Response.status((int)response.getResponseCode()).entity((Object)response.getBody()).build();
    }
}

