/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.graphql;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import graphql.GraphQLError;
import java.io.IOException;
import java.util.Map;
import org.owasp.encoder.Encode;

public class GraphQLErrorSerializer
extends StdSerializer<GraphQLError> {
    private final boolean encodeErrors;

    public GraphQLErrorSerializer(boolean encodeErrors) {
        super(GraphQLError.class);
        this.encodeErrors = encodeErrors;
    }

    public GraphQLErrorSerializer() {
        this(false);
    }

    public void serialize(GraphQLError value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Map errorSpec = value.toSpecification();
        gen.writeStartObject();
        gen.writeStringField("message", this.encodeErrors ? Encode.forHtml((String)((String)errorSpec.get("message"))) : (String)errorSpec.get("message"));
        if (errorSpec.containsKey("locations")) {
            gen.writeFieldName("locations");
            gen.writeObject(errorSpec.get("locations"));
        }
        if (errorSpec.containsKey("path")) {
            gen.writeFieldName("path");
            gen.writeObject(errorSpec.get("path"));
        }
        if (errorSpec.containsKey("extensions")) {
            gen.writeObject(errorSpec.get("extensions"));
        }
        gen.writeEndObject();
    }
}

